/*
 * Decompiled with CFR 0.152.
 */
package crayolon.portamod;

import crayolon.portamod.CellContent;
import crayolon.portamod.CurrentPattern;
import crayolon.portamod.CustomNote;
import crayolon.portamod.DataCell;
import crayolon.portamod.FastTracker2;
import crayolon.portamod.IBXM;
import crayolon.portamod.Instrument;
import crayolon.portamod.NoteData;
import crayolon.portamod.Player;
import crayolon.portamod.ProTracker;
import crayolon.portamod.Sample;
import crayolon.portamod.ScreamTracker3;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortaMod {
    PApplet p;
    GZIPInputStream zipin;
    Method noteArrived;
    Method noteArrivedB;
    String modpath = "";
    boolean keydown = false;
    boolean overridetempo = false;
    public String filepath;
    public int sequencecounter = 0;
    public int interpolation = 0;
    int[][][] current_row_notes;
    int currentrowcount;
    CurrentPattern temppattern;
    int pausedseq;
    int pausedrow;
    int specheight;
    int tempovalue;
    int seconds;
    int buffersize;
    int pausedpos = 0;
    int playpos = 0;
    int volvalue = 127;
    public int globvol = 64;
    public boolean paused = false;
    int posvalue = 0;
    public int loadSuccess = 0;
    int modseparation;
    int s3mpanning;
    public byte[] mod_header;
    public byte[] localmod_header;
    boolean fastforwardrow = false;
    boolean rewindrow = false;
    public int delayedchannel = -1;
    public boolean looping = false;
    public int transpose = 0;
    float volumelocal = 0.0f;
    int channels = 0;
    int currentsong = 0;
    int totalrows;
    int endcount = 0;
    float spectrumBars = 32.0f;
    float loopcount;
    public float minVol = -39.9f;
    public float maxVol = 6.019f;
    public boolean playing = false;
    public boolean muted = false;
    public long songStart;
    public long songLength;
    public long songPosition;
    String tunepath;
    String title;
    public int numchannels = 0;
    public int numinstruments = 0;
    public int bpmvalue = 0;
    float panning = 0.0f;
    public int initialtempo;
    public int numpatterns = 0;
    public String[] infotext;
    FileInputStream file_input_stream;
    public FloatControl volCtrl;
    public Player player;
    public Player delayplayerA;
    InputStream mymod;
    DataCell[] cells;
    BooleanControl muteCtrl;
    public NoteData localnotes;
    public NoteData thisrow;
    ArrayList<CurrentPattern> positions = new ArrayList();
    public ArrayList<CurrentPattern>[] currentpatternrows;
    public ArrayList<Instrument> oldsamples = new ArrayList();
    public ArrayList<CustomNote> delayednotes = new ArrayList();
    public CustomNote[] delaynotes;
    public int[] chantranspose;
    public int[] origloopstart;
    public int[] origlooplength;
    public int[] loopstart;
    public int[] looplength;
    public int[] sampledatalength;
    public CellContent[] cellcontent;
    public CellContent[] content;
    public String modtype;
    public int jamcounter = 0;
    int[] jamnote;
    int[] jaminst;
    public final String VERSION = "0.2.0";

    public PortaMod(PApplet p) {
        this.p = p;
        IBXM.SetMC(this);
        try {
            this.noteArrived = p.getClass().getMethod("grabNewdata", PortaMod.class);
        }
        catch (Exception e) {
            PApplet.println((String)e.getMessage());
        }
        try {
            this.noteArrivedB = p.getClass().getMethod("grabNewdataB", PortaMod.class);
        }
        catch (Exception e) {
            PApplet.println((String)e.getMessage());
        }
    }

    private void makeEvent(IBXM instance) {
        if (this.loadSuccess > 0) {
            if (this.noteArrived != null && instance == this.player.ibxm) {
                try {
                    this.noteArrived.invoke((Object)this.p, this);
                }
                catch (Exception e) {
                    System.err.println("Disabling noteArrived for  because of an error.");
                    e.printStackTrace();
                    this.noteArrived = null;
                }
            }
            if (this.noteArrivedB != null && instance == this.player.ibxm) {
                try {
                    this.noteArrivedB.invoke((Object)this.p, this);
                }
                catch (Exception e) {
                    System.err.println("Disabling noteArrivedB for  because of an error.");
                    e.printStackTrace();
                    this.noteArrived = null;
                }
            }
        }
    }

    public String version() {
        return "0.2.0";
    }

    public String getTitle() {
        String temptitle = new String();
        if (this.loadSuccess > 0) {
            temptitle = this.title;
        }
        return temptitle;
    }

    public void play() {
        if (this.paused) {
            this.player.play();
            this.paused = false;
        } else {
            this.player.play();
            this.songStart = this.p.millis();
        }
    }

    public void pause() {
        if (!this.paused) {
            this.player.stop();
            this.paused = true;
        }
    }

    public float getVol() {
        return this.volCtrl.getValue();
    }

    public void setVol(float newvol) {
        if (newvol > -40.0f && newvol < 6.02f) {
            try {
                this.volCtrl.setValue(newvol);
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        } else {
            PApplet.println((String)("Error - volume '" + newvol + "' is out of range. Must be between -40.0f and 6.020f!"));
        }
    }

    public void mute() {
        if (!this.muted) {
            try {
                this.muteCtrl.setValue(true);
                this.muted = true;
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        } else {
            try {
                this.muteCtrl.setValue(false);
                this.muted = false;
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        }
    }

    public void setTranspose(int chan, int trans) {
        if (chan < 0) {
            if (trans >= -12 && trans <= 12) {
                int i = 0;
                while (i < this.player.get_num_channels()) {
                    this.player.ibxm.channels[i].transposer = trans;
                    ++i;
                }
                this.transpose = trans;
            }
        } else if (trans >= -12 && trans <= 12) {
            this.player.ibxm.channels[chan].transposer = trans;
            this.chantranspose[chan] = trans;
        }
    }

    public int getTempo() {
        return this.bpmvalue;
    }

    public void setTempo(int tempo) {
        if (tempo > 32 && tempo < 255) {
            this.player.set_tempo(tempo);
            this.bpmvalue = tempo;
        }
    }

    public float getPanning() {
        return this.panning;
    }

    public void setPanning(float panval) {
        if (panval > -1.0f && panval < 1.0f) {
            try {
                FloatControl panctrl = (FloatControl)this.player.output_line.getControl(FloatControl.Type.BALANCE);
                panctrl.setValue(panval);
                this.panning = panval;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getChanmute(int chan) {
        return this.player.ibxm.chanmute[chan];
    }

    public void setChanmute(int chan, boolean flip) {
        if (chan < this.player.get_num_channels()) {
            this.player.ibxm.chanmute[chan] = flip;
        }
    }

    public void setSongloop(boolean flip) {
        this.player.loop = flip;
        System.out.println("Song looping is " + flip);
    }

    public int getChanvol(int chan) {
        int chanvol = this.player.ibxm.channels[chan].chanvolfinal;
        return (int)PApplet.map((float)chanvol, (float)0.0f, (float)12288.0f, (float)0.0f, (float)64.0f);
    }

    public void setChanvol(int chan, int vol) {
        this.player.ibxm.channels[chan].chanvol_override = vol;
    }

    public void setGlobvol(int vol) {
        if (vol >= 0 && vol <= 64) {
            this.globvol = vol;
            this.player.ibxm.global_volume[0] = vol;
        } else {
            System.out.println("Global volume must be between 0 and 64");
        }
    }

    public int getGlobvol() {
        return this.globvol;
    }

    public void setStereosep(int percentage) {
        int spread = (int)PApplet.map((float)percentage, (float)0.0f, (float)100.0f, (float)0.0f, (float)128.0f);
        if (this.modtype == "MOD") {
            this.player.ibxm.channels[0].set_panning(128 - spread);
            this.player.ibxm.channels[1].set_panning(128 + spread);
            this.player.ibxm.channels[2].set_panning(128 + spread);
            this.player.ibxm.channels[3].set_panning(128 - spread);
            if (this.player.get_num_channels() > 4) {
                this.player.ibxm.channels[4].set_panning(128 - spread);
                this.player.ibxm.channels[5].set_panning(128 + spread);
                this.player.ibxm.channels[6].set_panning(128 + spread);
                this.player.ibxm.channels[7].set_panning(128 - spread);
            }
        }
    }

    public void setInterpolation(int interp) {
        this.interpolation = interp;
    }

    public int getSeek() {
        if (this.playing) {
            try {
                this.songPosition = this.player.play_position / 48;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return (int)this.songPosition;
        }
        System.out.println("Couldn't get song position");
        return 0;
    }

    public void setSeek(int newpos) {
        this.player.seek(newpos * 48);
    }

    public void setOverridetempo(boolean flip) {
        this.player.ibxm.overridetempo = flip;
        System.out.println("Tempo override is " + flip);
    }

    public void sampleSwap(int idx, String inputpath, int offset) {
        byte[] sampbytes = this.p.loadBytes(inputpath);
        try {
            Instrument tempinst = this.replace_instrument(sampbytes, idx, sampbytes, offset);
            this.set_instrument(idx, tempinst);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sampleRestore(int idx) {
        try {
            if (this.oldsamples.get(idx - 1) != null) {
                Instrument tempinst_old = this.oldsamples.get(idx - 1);
                this.set_instrument(idx, tempinst_old);
            } else {
                System.out.println("Sample hasn't been replaced, so can't be restored!");
            }
        }
        catch (Exception e) {
            System.out.println("Sample hasn't been replaced, so can't be restored!");
        }
    }

    public int doModLoad(String tune, boolean autostart, int startVol) {
        this.filepath = tune;
        this.modpath = tune;
        this.headerCheck(tune);
        PApplet.println((String)("Header checked: " + this.modtype));
        if (this.loadSuccess > 0) {
            this.loadSuccess = 0;
        }
        InputStream file_input_stream = this.p.createInput(tune);
        try {
            if (this.playing) {
                this.player.stop();
                PApplet.println((String)"stopped");
            }
            this.player = new Player(this.interpolation);
            this.player.set_module(Player.load_module(file_input_stream));
            file_input_stream.close();
            this.player.set_loop(true);
            this.player.receivebuffer(this.buffersize);
            if (autostart) {
                this.player.play();
                this.songStart = this.p.millis();
            }
            this.setGlobvol(startVol);
            PApplet.println((String)this.player.get_title());
            PApplet.println((int)this.player.song_duration);
            this.songLength = this.player.song_duration / 48000;
            this.infotext = new String[this.player.get_num_instruments()];
            int i = 0;
            while (i < this.player.get_num_instruments()) {
                this.infotext[i] = "";
                Instrument tempinst_old = this.player.module.instruments[i];
                this.oldsamples.add(i, tempinst_old);
                if (this.player.ins_name(i) != null) {
                    PApplet.println((String)this.player.ins_name(i));
                    this.infotext[i] = this.player.ins_name(i);
                }
                ++i;
            }
            this.chantranspose = new int[this.player.get_num_channels()];
            int c = 0;
            while (c < this.player.get_num_channels()) {
                this.chantranspose[c] = 0;
                ++c;
            }
            this.loopstart = new int[this.player.get_num_instruments()];
            this.looplength = new int[this.player.get_num_instruments()];
            this.origloopstart = new int[this.player.get_num_instruments()];
            this.origlooplength = new int[this.player.get_num_instruments()];
            this.sampledatalength = new int[this.player.get_num_instruments()];
            int ins = 0;
            while (ins < this.player.get_num_instruments()) {
                this.origloopstart[ins] = 0;
                this.origlooplength[ins] = 0;
                this.sampledatalength[ins] = this.player.module.instruments[ins].samples[0].sample_data_length;
                this.origloopstart[ins] = this.player.module.instruments[ins].samples[0].loop_start;
                this.origlooplength[ins] = this.player.module.instruments[ins].samples[0].loop_length;
                ++ins;
            }
            PApplet.println((String)("Channels:" + this.player.get_num_channels()));
            try {
                this.muteCtrl = (BooleanControl)this.player.output_line.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
            this.title = this.player.get_title();
            this.numchannels = this.player.get_num_channels();
            this.jamnote = new int[this.player.get_num_channels()];
            this.jaminst = new int[this.player.get_num_channels()];
            c = 0;
            while (c < this.player.get_num_channels()) {
                this.jamnote[c] = 0;
                this.jaminst[c] = 0;
                ++c;
            }
            this.numinstruments = this.player.get_num_instruments();
            this.numpatterns = this.player.ibxm.module.get_sequence_length();
            this.playing = true;
            this.loadSuccess = 1;
            this.initialtempo = this.player.get_bpm();
            this.bpmvalue = this.player.get_bpm();
            this.currentrowcount = this.player.ibxm.total_rows;
            this.endcount = 0;
        }
        catch (Exception e) {
            PApplet.println((String)e.getMessage());
            PApplet.println((String)"Printing stack trace... ");
            e.printStackTrace();
        }
        return this.loadSuccess;
    }

    public void delayTap1(int channel, int volume) {
        try {
            InputStream file_input_stream = this.p.createInput(this.modpath);
            this.delayplayerA = new Player(this.interpolation);
            this.delayplayerA.set_module(Player.load_module(file_input_stream));
            file_input_stream.close();
            this.delayplayerA.set_loop(true);
            this.delayplayerA.receivebuffer(this.buffersize);
            int i = 0;
            while (i < this.delayplayerA.get_num_channels()) {
                if (i != channel) {
                    this.delayplayerA.ibxm.chanmute[i] = true;
                }
                ++i;
            }
            this.delayplayerA.ibxm.channels[channel].chanvol_override = volume;
            this.delayplayerA.play();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void doIt(IBXM instance, NoteData notedata) {
        this.localnotes = notedata;
        try {
            this.makeEvent(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sequencecounter = this.localnotes.currentseq;
        if (this.delayedchannel >= 0) {
            int cfr_ignored_0 = this.localnotes.channel;
        }
    }

    ArrayList<CurrentPattern>[] refreshpattern() {
        this.currentpatternrows = this.player.ibxm.all_rows();
        return this.currentpatternrows;
    }

    void displayCurrentpattern() {
        int thisrow = 0;
        while (thisrow < this.currentpatternrows[0].size()) {
            int channelcount = 0;
            while (channelcount < this.player.get_num_channels()) {
                try {
                    CurrentPattern tempdata = this.currentpatternrows[channelcount].get(thisrow);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++channelcount;
            }
            ++thisrow;
        }
    }

    public String noteConvert(int noteval) {
        String note = "";
        switch (noteval) {
            case 0: {
                note = "- -";
                break;
            }
            case 1: {
                note = "C-0";
                break;
            }
            case 2: {
                note = "C#0";
                break;
            }
            case 3: {
                note = "D-0";
                break;
            }
            case 4: {
                note = "D#0";
                break;
            }
            case 5: {
                note = "E-0";
                break;
            }
            case 6: {
                note = "F-0";
                break;
            }
            case 7: {
                note = "F#0";
                break;
            }
            case 8: {
                note = "G-0";
                break;
            }
            case 9: {
                note = "G#0";
                break;
            }
            case 10: {
                note = "A-0";
                break;
            }
            case 11: {
                note = "A#0";
                break;
            }
            case 12: {
                note = "B-0";
                break;
            }
            case 13: {
                note = "C-1";
                break;
            }
            case 14: {
                note = "C#1";
                break;
            }
            case 15: {
                note = "D-1";
                break;
            }
            case 16: {
                note = "D#1";
                break;
            }
            case 17: {
                note = "E-1";
                break;
            }
            case 18: {
                note = "F-1";
                break;
            }
            case 19: {
                note = "F#1";
                break;
            }
            case 20: {
                note = "G-1";
                break;
            }
            case 21: {
                note = "G#1";
                break;
            }
            case 22: {
                note = "A-1";
                break;
            }
            case 23: {
                note = "A#1";
                break;
            }
            case 24: {
                note = "B-1";
                break;
            }
            case 25: {
                note = "C-2";
                break;
            }
            case 26: {
                note = "C#2";
                break;
            }
            case 27: {
                note = "D-2";
                break;
            }
            case 28: {
                note = "D#2";
                break;
            }
            case 29: {
                note = "E-2";
                break;
            }
            case 30: {
                note = "F-2";
                break;
            }
            case 31: {
                note = "F#2";
                break;
            }
            case 32: {
                note = "G-2";
                break;
            }
            case 33: {
                note = "G#2";
                break;
            }
            case 34: {
                note = "A-2";
                break;
            }
            case 35: {
                note = "A#2";
                break;
            }
            case 36: {
                note = "B-2";
                break;
            }
            case 37: {
                note = "C-3";
                break;
            }
            case 38: {
                note = "C#3";
                break;
            }
            case 39: {
                note = "D-3";
                break;
            }
            case 40: {
                note = "D#3";
                break;
            }
            case 41: {
                note = "E-3";
                break;
            }
            case 42: {
                note = "E#3";
                break;
            }
            case 43: {
                note = "F-3";
                break;
            }
            case 44: {
                note = "G-3";
                break;
            }
            case 45: {
                note = "G#3";
                break;
            }
            case 46: {
                note = "A-3";
                break;
            }
            case 47: {
                note = "A#3";
                break;
            }
            case 48: {
                note = "B-3";
                break;
            }
            case 49: {
                note = "C-4";
                break;
            }
            case 50: {
                note = "C#4";
                break;
            }
            case 51: {
                note = "D-4";
                break;
            }
            case 52: {
                note = "D#4";
                break;
            }
            case 53: {
                note = "E-4";
                break;
            }
            case 54: {
                note = "F-4";
                break;
            }
            case 55: {
                note = "F#4";
                break;
            }
            case 56: {
                note = "G-4";
                break;
            }
            case 57: {
                note = "G#4";
                break;
            }
            case 58: {
                note = "A-4";
                break;
            }
            case 59: {
                note = "A#4";
                break;
            }
            case 60: {
                note = "B-4";
                break;
            }
            case 61: {
                note = "C-5";
                break;
            }
            case 62: {
                note = "C#5";
                break;
            }
            case 63: {
                note = "D-5";
                break;
            }
            case 64: {
                note = "D#5";
                break;
            }
            case 65: {
                note = "E-5";
                break;
            }
            case 66: {
                note = "F-5";
                break;
            }
            case 67: {
                note = "F#5";
                break;
            }
            case 68: {
                note = "G-5";
                break;
            }
            case 69: {
                note = "G#5";
                break;
            }
            case 70: {
                note = "A-5";
                break;
            }
            case 71: {
                note = "A#5";
                break;
            }
            case 72: {
                note = "B-5";
                break;
            }
            case 73: {
                note = "C-6";
                break;
            }
            case 74: {
                note = "C#6";
                break;
            }
            case 75: {
                note = "D-6";
                break;
            }
            case 76: {
                note = "D#6";
                break;
            }
            case 77: {
                note = "E-6";
                break;
            }
            case 78: {
                note = "F-6";
                break;
            }
            case 79: {
                note = "F#6";
                break;
            }
            case 80: {
                note = "G-6";
                break;
            }
            case 81: {
                note = "G#6";
                break;
            }
            case 82: {
                note = "A-6";
                break;
            }
            case 83: {
                note = "A#6";
                break;
            }
            case 84: {
                note = "B-6";
                break;
            }
            case 85: {
                note = "C-7";
                break;
            }
            case 86: {
                note = "C#7";
                break;
            }
            case 87: {
                note = "D-7";
                break;
            }
            case 88: {
                note = "D#7";
                break;
            }
            case 89: {
                note = "E-7";
                break;
            }
            case 90: {
                note = "F-7";
                break;
            }
            case 91: {
                note = "F#7";
                break;
            }
            case 92: {
                note = "G-7";
                break;
            }
            case 93: {
                note = "G#7";
                break;
            }
            case 94: {
                note = "A-7";
                break;
            }
            case 95: {
                note = "A#7";
                break;
            }
            case 96: {
                note = "B-7";
                break;
            }
            case 97: {
                note = "=";
            }
        }
        return note;
    }

    public boolean headerCheck(String tune) {
        boolean valid = false;
        if (this.p.createInput(tune) == null) {
            System.out.println("PortaMod says: couldn't find the file when performing a header check. Please check the filename and path.");
        } else {
            InputStream file_input_stream = this.p.createInput(tune);
            String headercheck = "unknown";
            DataInputStream data_input_stream = new DataInputStream(file_input_stream);
            byte[] xm_header = new byte[60];
            try {
                data_input_stream.readFully(xm_header);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String xm_identifier = FastTracker2.ascii_text(xm_header, 0, 17);
            if (xm_identifier.equals("Extended Module: ")) {
                headercheck = "xm";
                this.modtype = "XM";
            }
            byte[] s3m_header = new byte[96];
            System.arraycopy(xm_header, 0, s3m_header, 0, 60);
            try {
                data_input_stream.readFully(s3m_header, 60, 36);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (ScreamTracker3.is_s3m(s3m_header)) {
                headercheck = "s3m";
                this.modtype = "S3M";
            }
            this.mod_header = new byte[1084];
            System.arraycopy(s3m_header, 0, this.mod_header, 0, 96);
            try {
                data_input_stream.readFully(this.mod_header, 96, 988);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.localmod_header = this.mod_header;
            if (ProTracker.is_mod(this.mod_header)) {
                headercheck = "mod";
                this.modtype = "MOD";
            }
            valid = headercheck == "xm" || headercheck == "s3m" || headercheck == "mod";
        }
        return valid;
    }

    Instrument replace_instrument(byte[] mod_header, int idx, byte[] data_input, int replacetranspose) throws IOException {
        int header_offset = (idx - 1) * 30 + 20;
        Instrument instrument = new Instrument();
        Sample sample = new Sample();
        int sample_data_length = data_input.length;
        System.out.println("Sampledata bytes: " + sample_data_length);
        int fine_tune = mod_header[header_offset + 24] & 0xF;
        if (fine_tune > 7) {
            fine_tune -= 16;
        }
        sample.transpose = (fine_tune + replacetranspose * 10 << 15) / 96;
        sample.volume = mod_header[header_offset + 25] & 0x7F;
        int loop_start = PortaMod.unsigned_short_be(mod_header, header_offset + 26) << 1;
        int loop_length = PortaMod.unsigned_short_be(mod_header, header_offset + 28) << 1;
        if (loop_length < 4) {
            loop_length = 0;
        }
        short[] sample_data = new short[sample_data_length];
        int sample_idx = 0;
        while (sample_idx < data_input.length) {
            sample_data[sample_idx] = (short)(data_input[sample_idx] << 8);
            ++sample_idx;
        }
        sample.set_sample_data(sample_data, loop_start, loop_length, false);
        instrument.set_num_samples(1);
        instrument.set_sample(0, sample);
        return instrument;
    }

    public void customkeyDown(int note, int inst, String vol, String effect, String effparam) {
        if (this.jamcounter >= this.jamnote.length) {
            this.jamcounter = 0;
        }
        CustomNote temp = new CustomNote();
        temp.channel = this.jamcounter;
        temp.note = note;
        temp.inst = inst;
        temp.vol = Integer.parseInt(vol, 16);
        temp.effect = Integer.parseInt(effect, 16);
        temp.effparam = Integer.parseInt(effparam, 16);
        this.player.ibxm.customnote = temp;
        if (!this.keydown) {
            this.player.ibxm.keydown[temp.channel] = true;
        }
        this.jamnote[this.jamcounter] = note;
        this.jaminst[this.jamcounter] = inst;
        ++this.jamcounter;
    }

    public void delaykeyDown(int note, int inst, int vol, int effect, int effparam) {
        if (this.jamcounter >= this.jamnote.length) {
            this.jamcounter = 0;
        }
        CustomNote temp = new CustomNote();
        temp.channel = this.jamcounter;
        temp.note = note;
        temp.inst = inst;
        temp.vol = vol;
        temp.effect = effect;
        temp.effparam = effparam;
        this.player.ibxm.customnote = temp;
        if (!this.keydown) {
            this.player.ibxm.keydown[temp.channel] = true;
        }
        this.jamnote[this.jamcounter] = note;
        this.jaminst[this.jamcounter] = inst;
        ++this.jamcounter;
    }

    public void channelDelay(int chan, int delaytime, int delaysend) {
        this.delayedchannel = chan;
    }

    public void effector(int chan, String effect, String effparam) {
        CustomNote temp = new CustomNote();
        temp.channel = chan;
        temp.note = 0;
        temp.inst = 0;
        temp.vol = 40;
        temp.effect = Integer.parseInt(effect, 16);
        temp.effparam = Integer.parseInt(effparam, 16);
        this.player.ibxm.effector[chan] = true;
        this.player.ibxm.customnote = temp;
        if (!this.keydown) {
            this.player.ibxm.keydown[temp.channel] = true;
        }
    }

    public void customkeyUp(int note, int inst) {
        if (note > 0) {
            int i = 0;
            while (i < this.jamnote.length) {
                if (this.jamnote[i] == note && this.jaminst[i] == inst) {
                    this.player.ibxm.keydown[i] = false;
                    this.player.ibxm.jamchans[i].reset();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.jamnote.length) {
                this.player.ibxm.keydown[i] = false;
                this.player.ibxm.jamchans[i].reset();
                ++i;
            }
        }
        this.keydown = false;
    }

    public void loopStart(int inst, int newloopstart) {
        int samplelength = this.player.module.instruments[inst].samples[0].sample_data_length;
        int temp_loopstart = samplelength / 100 * newloopstart;
        if (temp_loopstart < samplelength) {
            if (temp_loopstart < samplelength) {
                this.player.module.instruments[inst].samples[0].loop_start = temp_loopstart;
                this.loopstart[inst] = temp_loopstart;
            } else {
                this.player.module.instruments[inst].samples[0].loop_length = temp_loopstart;
                this.looplength[inst] = temp_loopstart;
            }
        }
    }

    public void loopLength(int inst, int newlooplength) {
        int temp_looplength = 0;
        int samplelength = this.player.module.instruments[inst].samples[0].sample_data_length;
        int availabledata = samplelength - 4 - this.loopstart[inst];
        this.player.module.instruments[inst].samples[0].loop_length = temp_looplength = availabledata / 100 * newlooplength;
        this.looplength[inst] = temp_looplength;
    }

    public void loopReset(int inst) {
        this.player.module.instruments[inst].samples[0].loop_start = this.origloopstart[inst];
        this.player.module.instruments[inst].samples[0].loop_length = this.origlooplength[inst];
        this.loopstart[inst] = this.origloopstart[inst];
        this.looplength[inst] = this.origlooplength[inst];
    }

    public void sampleDump() {
        if (this.loadSuccess > 0) {
            try {
                int i = 0;
                while (i < this.player.get_num_instruments() - 1) {
                    Sample sampshort = new Sample();
                    sampshort = this.player.module.instruments[i].get_sample(i);
                    byte[] samp = new byte[sampshort.sample_data.length];
                    int j = 0;
                    while (j < sampshort.sample_data.length) {
                        samp[j] = (byte)(sampshort.sample_data[j] >> 8 & 0xFF);
                        ++j;
                    }
                    this.p.saveBytes(String.valueOf(this.player.ins_name(i)) + i + ".raw", samp);
                    System.out.println("Sample " + i + " written to disk.");
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void set_instrument(int instrument_index, Instrument instrument) {
        if (instrument_index > 0 && instrument_index <= this.player.module.instruments.length) {
            this.player.module.instruments[instrument_index - 1] = instrument;
        }
    }

    private static int unsigned_short_be(byte[] buf, int offset) {
        int value = (buf[offset] & 0xFF) << 8;
        return value |= buf[offset + 1] & 0xFF;
    }

    public int getCurrent_sequence_index() {
        return this.player.ibxm.current_sequence_index;
    }

    public int getCurrent_row() {
        return this.player.ibxm.current_row;
    }

    public int getNext_sequence_index() {
        return this.player.ibxm.next_sequence_index;
    }

    public int getNext_row() {
        return this.player.ibxm.next_row;
    }

    public void setNext_sequence_index(int newpos, int behaviour) {
        if (behaviour == 0) {
            this.player.ibxm.next_sequence_index = newpos;
        }
        if (behaviour == 1) {
            this.player.ibxm.next_sequence_index = newpos;
            this.player.ibxm.next_row = 0;
        }
    }

    public void setNext_row(int newrow) {
        if (newrow < this.player.ibxm.total_rows && newrow >= 0) {
            this.player.ibxm.next_row = newrow;
        }
    }

    public void stop() {
        this.player.stop();
    }
}

