uniform sampler2D tex0;
uniform float gamma = 0.6;
uniform float time;

void main() 
{ 
  float numColors = (1.0 - time) * 8.0;
  vec3 c = texture2D(tex0, gl_TexCoord[0].xy).rgb;
  c = pow(c, vec3(gamma, gamma, gamma));
  c = c * numColors;
  c = floor(c);
  c = c / numColors;
  c = pow(c, vec3(1.0/gamma));
  gl_FragColor = vec4(c, 1.0);
}
