//==========================================================
// "MAKE DEMOS NOT 1K INTROS" by deMarche
// zx spectrum 1k intro for Chaos Constructions 2013
// code & music by TmK
//==========================================================
	DEVICE	ZXSPECTRUM128
//---------------------------
COS	EQU	#9000
	ORG	#8000
	;--- init screen
	DI
	CALL	SOUND_INIT
	XOR	A
	OUT	(#FE),A
	LD	HL,#5AFF
	LD	DE,#5AFE
	LD	BC,#0300
	LD	(HL),C
	LDDR
	LD	BC,#17FF
	LD	A,B
	LD	(HL),#F0
	LDDR
	LD	BC,#7FFD
	OUT	(C),A
	LD	DE,#C000
	LD	BC,#1B00
	LDIR
	;--- init interrupts
	LD	A,#BE
	LD	I,A
	IM	2
	LD	H,A
	LD	D,A
	INC	E
	LD	B,E
	INC	A
	LD	(HL),A
	LDIR
	LD	D,A
	LD	E,A
	LD	HL,INT
	INC	B
	LDIR
	;--- init cos 128b->256b
	LD	HL,COS1
	LD	DE,COS
	LD	B,129
LL	LD	A,(HL)
	LDI
	ADD	A,(HL)
	SRL	A
	LD	(DE),A
	INC	E
	DJNZ	LL
	DEC	E
	LD	A,#3F
	LD	(DE),A
	CALL	INIT1
	CALL	INIT2
EFF	//-----------------
	EI
	HALT
	LD	A,192-1
EFF_A	EQU	$-1
	DEC	A
	JR	NZ,EFF_B
	LD	A,7
	OUT	(#FE),A
	LD	HL,#D800
	LD	DE,#D801
	LD	BC,#02FF
	LD	(HL),#3F
	LDIR
	CALL	SOUND
	HALT
	CALL	SOUND
	CALL	INIT1
	CALL	SOUND
	CALL	INIT2
	CALL	SOUND	
	HALT
	XOR	A
	OUT	(#FE),A
	LD	A,192-4
EFF_B	LD	(EFF_A),A
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;--pause
	LD	BC,PAUSE1
P1	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,P1
	;---
	EXX
	LD	DE,#5800
	LD	LX,24
	EXX
	LD	H,COS/256
	LD	B,H
	;---
	LD	A,0
X1COS	EQU	$-1
	ADD	A,0-5
XX1	EQU	$-1
	LD	(X1COS),A
	LD	L,A
	LD	A,32
X2COS	EQU	$-1
	ADD	A,3
XX2	EQU	$-1
	LD	(X2COS),A
	LD	C,A
LP1	//---------------
	CALL	LINE		;17 +603
	EX	DE,HL		;4
	LD	BC,0-32		;10
	ADD	HL,BC		;11
	EX	DE,HL		;4
	SET	7,D		;8
	LD	A,#17		;7
	LD	BC,#7FFD	;10
	LD	BC,#7FFD	;10
	OUT	(C),A		;12
	EXX			;4
	;---
	LD	A,PAUSE2
LP2	DEC	A
	JR	NZ,LP2 ;12.7 16*12-5+7=/194
	;---
	CALL	LINE		;17 +603
	RES	7,D		;8
	LD	A,#17+8		;7
	LD	BC,#7FFD	;10
	OUT	(C),A		;12 /58 679
	EXX			;4
	;--
	LD	A,PAUSE3
	LD	A,PAUSE3
LP3	DEC	A
	JR	NZ,LP3	;16*13-5+7=/217
	DEC	LX	;8
	JR	NZ,LP1	;10 /18 //615
	CALL	SOUND
	JP	EFF	;10
LINE	//------------------
	LD	A,C	;4
	ADD	A,8	;7
	LD	C,A	;4
	LD	A,L	;4
	SUB	4	;7
	LD	L,A	;4
	LD	A,(BC)	;7
	ADD	A,(HL)	;7
	RRA		;4
	RRA		;4
	AND	31	;7
	ADD	A,#E0	;7
	EXX		;4
	LD	L,#80	;7
	LD	H,A	;4 /81
	//---
	DUP	32
	LDI		;16 /512
	EDUP
	//---
	RET		;10 /10 //603
//--------------------------
XCODE	;--
	DB	#38	;JR	C
	DB	4
	XOR	A
	NOP
	NOP
	NOP
	;--
	DB	#38	;JR	C
	DB	4
	NEG
	AND	7
	;--
	DB	#38	;JR	C
	DB	4
	AND	3
	NOP
	NOP
	;--
	DB	#30	;JR	NC
	DB	2
	AND	3
	AND	7
	;--
	DB	#00
INIT1	LD	HL,XCODE
	LD	A,(HL)
	OR	A
	JR	NZ,INIT11
	LD	HL,XCODE
INIT11	LD	DE,CODE
	LDI:LDI:LDI:LDI:LDI:LDI
	LD	(INIT1+1),HL
INIT111	;--- calc texture
	LD	IY,COS+128+20
	LD	HX,32
	LD	DE,64
	LD	B,#E0
I0_2	LD	HL,#0100
	LD	C,0
	LD	LX,32
I0_1	ADD	HL,DE
	LD	A,H
	CP	8
CODE	JR	C,I0_3
	NEG
	AND	7
I0_3	LD	(BC),A
	INC	C
	DEC	LX
	JR	NZ,I0_1
	LD	A,(IY)
	SRL	A
	ADD	A,E
	LD	E,A
	ADC	A,D
	SUB	E
	LD	D,A
	INC	LY
	INC	B
	DEC	HX
	JR	NZ,I0_2
	RET
INIT2	LD	H,#E0
	LD	C,32
I0_5	LD	B,32
	LD	D,H
	LD	E,31+#80
	LD	L,31
I0_4	LD	A,(HL)
	DEC	L
	ADD	A,A
	ADD	A,A
	ADD	A,A
	AND	%00111000
	OR	(HL)
	DEC	L
	LD	(DE),A
	DEC	E
	DJNZ	I0_4
	INC	H
	DEC	C
	JR	NZ,I0_5
	LD	HL,#E000
	LD	C,32
I0_5x	LD	B,32
	LD	D,H
	LD	E,15+#80
I0_4x	LD	A,(HL)
	INC	L
	ADD	A,A
	ADD	A,A
	ADD	A,A
	AND	%00111000
	OR	(HL)
	INC	L
	LD	(DE),A
	DEC	E
	DJNZ	I0_4x
	LD	L,B
	INC	H
	DEC	C
	JR	NZ,I0_5x
	RET
INT	DI
	EI
	RET
COS1	incbin	"cos.bin"
SOUND_INIT
	LD	HL,TRACK
TRACK_ADR EQU	$-2
	LD	A,(HL)
	OR	A
	JR	NZ,SI1
	LD	HL,TRACK
SI1	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(TRACK_ADR),HL
	EX	DE,HL
	LD	DE,CODEEND
	LD	BC,PATT_2-PATT_1
	LDIR
	LD	A,96
	RET
SOUND	LD	A,97
	DEC	A
	CALL	Z,SOUND_INIT
	LD	(SOUND+1),A
	LD	BC,#BFFD
	EXX
	LD	BC,#FFFD
	LD	IX,CODEEND
	;---
	CALL	SND2
	CALL	SND2
	CALL	SND1
	CALL	SND1
	CALL	SND1
	CALL	SND2
	CALL	SND1
	CALL	SND1
	CALL	SND0
;--------------------------
SND0	LD	E,(IX+2)
	LD	D,(IX+3)
	LD	A,(IX+1)
	JR	SND00
;--------------------------
SND1	LD	H,1
	JR	SND
SND2	LD	H,0
SND	DEC	(IX)
	JR	NZ,SND_RET
	LD	E,(IX+2)
	LD	D,(IX+3)
	LD	A,(DE)
	LD	(IX),A
	INC	DE
	LD	A,(IX+1)
	OUT	(C),A
	EX	AF,AF
	LD	A,(DE)
	INC	DE
	EXX
	OUT	(C),A
	EXX
	DEC	H
	JR	Z,SNDD
	EX	AF,AF
	INC	A
SND00	OUT	(C),A
	LD	A,(DE)
	INC	DE
	EXX
	OUT	(C),A
	EXX
SNDD	LD	(IX+2),E
	LD	(IX+3),D
SND_RET	LD	DE,4
	ADD	IX,DE
	RET
;--------------------------
SND_DATA
ENV	;---
	DB	6,#0E
	DB	6,#0C
	DB	12,#0E
	DB	12,#08
	DB	6,#0E
	DB	6,#0C
	DB	24,#0E
	DB	12,#0C
	DB	12,#0E
NOISE	;---
	DB	12,#00
	DB	1,#07,11,#00
	DB	1,#0F,11,#00
	DB	1,#07,17,#00
	DB	1,#0F,17,#00
	DB	1,#0F,11,#00
	DB	1,#07,11,#00
REG	;---
	DB	6,#38
	DB	3,#3C
	DB	3,#34
	DB	1,#18
	DB	11,#1C
	DB	1,#18
	DB	8,#1C
	DB	3,#14
	DB	1,#18
	DB	5,#1C
	DB	3,#3C
	DB	3,#34
	DB	6,#3C
	DB	1,#18
	DB	2,#1C
	DB	3,#14
	DB	6,#38
	DB	6,#3C
	DB	1,#18
	DB	8,#1C
	DB	3,#14
	DB	1,#18
	DB	5,#1C
	DB	3,#38
	DB	3,#30
TONE_ENV ;---
	DB	96,#35,#00
TONE_ENV2 ;---
	DB	96,#47,#00
VOL_A	;---
	DB	9,#18
	DB	3,#00
	DB	21,#18
	DB	3,#00
	DB	9,#18
	DB	3,#00
	DB	9,#18
	DB	3,#00
	DB	21,#18
	DB	3,#00
	DB	9,#18
	DB	3,#00
VOL_C	;---
	incbin volume_c.bin
	ORG	$-1
	DB	#FF
VOL_B	;---
	DB	6,#0A-1
	DB	12,#06-1
	;-
	DB	6,#0B-1
	DB	1,#09-1
	DB	1,#0B-1
	DB	1,#08-1
	DB	1,#0B-1
	DB	8,#08-1
	;-
	DB	6,#0C-1
	DB	6,#08-1
	DB	6,#0A-1
	DB	12,#06-1
	;-
	DB	6,#0B-1
	DB	1,#09-1
	DB	1,#0B-1
	DB	1,#08-1
	DB	1,#0B-1
	DB	8,#08-1
	;-
	DB	6,#0C-1
	DB	6,#08-1
	
TONE_A	;---
	DB	12,#60,#0D
	DB	24,#58,#03
	DB	12,#38,#02
	DB	12,#60,#0D
	DB	12,#AC,#01
	DB	12,#1C,#01
	DB	12,#58,#03
TONE_A2	;---
	DB	12,#E0,#08
	DB	12,#70,#04
	DB	12,#1C,#01
	DB	12,#F6,#02
	DB	12,#E0,#08
	DB	12,#38,#02
	DB	12,#7B,#01
	DB	12,#70,#04
TONE_B	;---
	DUP	32
	DB	#47,#35,#6B
	EDUP
TONE_B2	;---
	DUP	32
	DB	#5E,#47,#8E
	EDUP
TONE_C	;---
	DB	1,#D8,#04
	DB	1,#18,#06
	DB	1,#38,#07
	DB	1,#38,#08
	DB	1,#18,#09
	DB	1,#D8,#09
	DB	6,#58,#03
	DB	30,#1C,#00
	DB	12,#58,#03
	DB	6,#1C,#00
	DB	1,#D8,#04
	DB	1,#18,#06
	DB	1,#38,#07
	DB	1,#38,#08
	DB	1,#18,#09
	DB	7,#D8,#09
	DB	18,#1C,#00
	DB	1,#D8,#04
	DB	1,#18,#06
	DB	1,#38,#07
	DB	1,#38,#08
	DB	1,#18,#09
	DB	1,#D8,#09
	
PATT_1		;--------------
ADR_TONE_A	DB	1,0
		DW	TONE_A
ADR_TONE_C	DB	1,4
		DW	TONE_C
ADR_NOISE	DB	1,6
		DW	NOISE
ADR_REG		DB	1,7
		DW	REG
ADR_VOL_A	DB	1,8
		DW	VOL_A
ADR_TONE_ENV	DB	1,#0B
		DW	TONE_ENV
ADR_ENV		DB	1,#0D
		DW	ENV
		DB	1,9
		DW	VOL_B
		DB	#FF,10
		DW	VOL_C
		DB	#FF,2
		DW	TONE_B
PATT_2		;--------------
ADR_TONE_A2	DB	1,0
		DW	TONE_A2
ADR_TONE_C2	DB	1,4
		DW	TONE_C
ADR_NOISE2	DB	1,6
		DW	NOISE
ADR_REG2	DB	1,7
		DW	REG
ADR_VOL_A2	DB	1,8
		DW	VOL_A
ADR_TONE_ENV2	DB	1,#0B
		DW	TONE_ENV2
ADR_ENV2	DB	1,#0D
		DW	ENV
		DB	1,9
		DW	VOL_B
		DB	#FF,10
		DW	VOL_C
		DB	#FF,2
		DW	TONE_B2
		;--------------
TRACK	DW PATT_1,PATT_1,PATT_2,PATT_2
	DB	#00
CODEEND
//==========================================================
	DISPLAY /A,CODEEND-#8000
	DISPLAY /A,LP2
//==========================================================
	SAVEBIN	"intro.bin",#8000,CODEEND-#8000
//==========================================================