package com.geekparty.shooter.view.screens {
	import com.geekparty.shooter.core.managers.ScreenManager;
	import com.geekparty.shooter.view.Screen;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class Splash extends Screen {
		
		private var layout:UI_screen_loader;
		
		public function Splash() {
			initLayout();
		}
		
		private function initLayout():void {
			layout = new UI_screen_loader();
			addChild(layout);
		}
		
		override public function get type():int {
			return Screen.TYPE_SPLASH;
		}
		
		override public function init():void {
			if (initialized) {
				return;
			}
			super.init();
		}
		
		override public function hide():void {
			super.hide();
		}
		
		private var timer:Timer;
		
		override public function show():void {
			super.show();
			timer = new Timer(500, 1);
			timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
			timer.start();
		
		}
		
		private function onTimerComplete(e:TimerEvent):void {
			timer.stop();
			timer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
			timer = null;
			ScreenManager.instance.changeScreen(Screen.TYPE_MAIN_MENU);
		}
	}
}