package com.geekparty.shooter.view.screens {
	import com.geekparty.shooter.core.managers.ScreenManager;
	import com.geekparty.shooter.view.Screen;
	import flash.display.SimpleButton;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class Options extends Screen {
		
		private var layout:UI_screen_options;
		private var closeButton:SimpleButton;
		
		public function Options() {
			initLayout();
		}
		
		private function initLayout():void {
			layout = new UI_screen_options();
			closeButton = layout.getChildByName('close') as SimpleButton;
			addChild(layout);
		}
		
		override public function get type():int {
			return Screen.TYPE_OPTIONS;
		}
		
		override public function init():void {
			if (initialized) {
				return;
			}
			super.init();
		}
		
		override public function hide():void {
			super.hide();
			closeButton.removeEventListener(MouseEvent.CLICK, onCloseClick);
		}
		
		override public function show():void {
			super.show();
			closeButton.addEventListener(MouseEvent.CLICK, onCloseClick);
		}
		
		private function onCloseClick(e:MouseEvent):void {
			ScreenManager.instance.changeScreen(Screen.TYPE_MAIN_MENU);
		}
	}
}