package com.geekparty.shooter.view.screens {
	import com.geekparty.shooter.core.managers.*;
	import com.geekparty.shooter.view.*;
	import flash.display.*;
	import flash.events.*;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class MainMenu extends Screen {
		
		private var layout:UI_screen_main_menu;
		
		private var button_options:SimpleButton;
		private var button_game:SimpleButton;
		
		public function MainMenu() {
			initLayout();
		}
		
		private function initLayout():void {
			layout = new UI_screen_main_menu();
			
			button_options = layout.getChildByName('options') as SimpleButton;
			button_game = layout.getChildByName('game') as SimpleButton;
			
			addChild(layout);
		}
		
		override public function get type():int {
			return Screen.TYPE_MAIN_MENU;
		}
		
		override public function init():void {
			if (initialized) {
				return;
			}
			super.init();
		}
		
		override public function hide():void {
			super.hide();
			button_options.removeEventListener(MouseEvent.CLICK, onOptionsClick);
			button_game.removeEventListener(MouseEvent.CLICK, onGameClick);
		}
		
		override public function show():void {
			super.show();
			
			button_options.addEventListener(MouseEvent.CLICK, onOptionsClick);
			button_game.addEventListener(MouseEvent.CLICK, onGameClick);
		}
		
		private function onGameClick(e:MouseEvent):void {
			ScreenManager.instance.changeScreen(Screen.TYPE_GAME);
		}
		
		private function onOptionsClick(e:MouseEvent):void {
			ScreenManager.instance.changeScreen(Screen.TYPE_OPTIONS);
		}
	}
}