package com.geekparty.shooter.view.game.enemies {
	import com.geekparty.shooter.Main;
	import com.geekparty.shooter.view.game.Enemy;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.utils.Timer;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class UnderwaterMine extends Enemy {
		
		private var layout:UI_underwater_mine;
		
		private var speed:Number;
		private var tick:int;
		private var bombTick:int;
		private var removeCallBack:Function;
		private var waveNumber:Number;
		private var destroyed:Boolean;
		private var my_filter:ColorMatrixFilter;
		private var boom:MovieClip;
		
		override public function get addingHeight():int {
			return 600;
		}
		
		public function init(removeCallBack:Function):void {
			this.removeCallBack = removeCallBack;
		}
		
		public function UnderwaterMine() {
			speed = 5;
			layout = new UI_underwater_mine();
			boom = layout.getChildByName('boom') as MovieClip;
			boom.visible = false;
			addChild(layout);
			waveNumber = 0;
			life = 15;
			blinkTimer = new Timer(30);
			blinkTimes = blinks;
			blinkTimer.addEventListener(TimerEvent.TIMER, blink);
			
			var matrix:Array = new Array();
			matrix = matrix.concat([0.5, 0.5, 0.5, 0, 0]); // red
			matrix = matrix.concat([0.5, 0.5, 0.5, 0, 0]); // green
			matrix = matrix.concat([0.5, 0.5, 0.5, 0, 0]); // blue
			matrix = matrix.concat([0, 0, 0, 0.5, 0]); // alpha
			my_filter = new ColorMatrixFilter(matrix);
		}
		
		override public function getScore():int 
		{
			return 600;
		}
		
		private function blink(e:TimerEvent):void {
			if (blinkTimes-- <= 0) {
				blinkTimer.stop();
				blinkTimer.reset();
				blinkTimes = blinks;
				return;
			}
			filters = (filters.length == 0) ? [my_filter] : [];
		}
		
		private static const blinks:int = 4;
		
		private var blinkTimes:int;
		private var blinkTimer:Timer;
		
		override public function damage(damage:int):Boolean {
			life -= damage;
			if (life <= 0) {
				destroy();
				return true;
			}
			blinkTimer.start();
			return false;
		}
		
		override public function move():void {
			x -= speed;
			if (x < -300) {
				remove();
			} else {
				var arg:Number = Math.sin(waveNumber) * 0.5;
				layout.rotation = arg * 5;
				waveNumber += 0.3;
				if (waveNumber >= 60) {
					waveNumber = 0;
					y = addingHeight;
				}
				y += arg;
			}
		}
		
		override public function remove():void {
			removeCallBack(this);
			parent.removeChild(this);
		}
		
		override public function destroy():void {
			removeCallBack(this);
			boom.visible = true;
			var mine:MovieClip = layout.getChildByName('mine') as MovieClip;
			mine.visible = false;
			boom.addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		private function onFrame(e:Event):void {
			boom.alpha -= 0.01;
			if (boom.currentFrame == boom.totalFrames - 1) {
				boom.removeEventListener(Event.ENTER_FRAME, onFrame);
				parent.removeChild(this);
			}
		}
		
		override public function get hit_area():MovieClip {
			return layout.getChildByName('hit') as MovieClip;
		}
		
		override public function stop():void {
			layout.stop();
		}
	}
}