package com.geekparty.shooter.view.game {
	import com.geekparty.shooter.core.managers.ScreenManager;
	import com.geekparty.shooter.view.Screen;
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class GameOver extends Sprite {
		
		private var layout:UI_game_over;
		
		private var score:TextField;
		private var restart:SimpleButton;
		
		public function GameOver() {
			graphics.beginFill(0, 0.4);
			graphics.drawRect(0, 0, 800, 600);
			graphics.endFill();
			
			layout = new UI_game_over();
			addChild(layout);
			layout.x = 400;
			layout.y = 300;
			
			score = layout.getChildByName('score') as TextField;
			score.selectable = false;
			
			restart = layout.getChildByName('restart') as SimpleButton;
			restart.addEventListener(MouseEvent.CLICK, onRestartClick);
		
		}
		
		public function setScore(v:int):void {
			score.text = 'SCORE: ' + v;
		}
		
		private function onRestartClick(e:MouseEvent):void {
			ScreenManager.instance.changeScreen(Screen.TYPE_MAIN_MENU);
			ScreenManager.instance.changeScreen(Screen.TYPE_GAME);
		}
	}
}