package com.geekparty.shooter.view.game {
	import flash.display.Sprite;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class CloudsGenerator {
		
		private static var TYPE_UNDERWATER_MINE:int = 0;
		
		public var clouds:Vector.<Cloud>;
		private var container:Sprite;
		private var randomTime:Number;
		private var enemyTick:int;
		
		private var enemy_id:int;
		private var generateTime:Number;
		
		private function get enemyID():int {
			enemy_id++;
			return enemy_id;
		}
		
		public function CloudsGenerator() {
			clouds = new Vector.<Cloud>();
			enemyTick = 0;
			generateTime = 5;
			setRandom();
			enemy_id = -1;
		}
		
		private function setRandom():void {
			randomTime = Math.random() * 5;
		}
		
		public function init(container:Sprite):void {
			this.container = container;
		}
		
		public function tick():void {
			enemyTick++;
			if (enemyTick >= (generateTime + randomTime)) {
				generateNewOne();
				enemyTick = 0;
				setRandom();
			}
			var i:int;
			for (i = 0; i < clouds.length; i++) {
				clouds[i].move();
			}
		}
		
		public function stop():void {
			var i:int;
			for (i = 0; i < clouds.length; i++) {
				clouds[i].stop();
			}
		}
		
		private function generateNewOne():void {
			var choice:Array = [Assets.cloud1, Assets.cloud2, Assets.cloud3];
			var speed:Array = [15, 25, 35];
			var randomNumber:int = Math.floor(Math.random() * 3);
			
			var cloud:Cloud = new Cloud(choice[randomNumber], speed[randomNumber]);
			cloud.init(removeCallBack);
			clouds.push(cloud);
			container.addChild(cloud);
			cloud.y = Math.random() * 200;
			cloud.x = 800;
		}
		
		private function removeCallBack(e:Cloud):void {
			var i:int = clouds.indexOf(e);
			clouds.splice(i, 1);
		
		}
	}
}