package com.geekparty.shooter.view.components {
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class Shaker {
		private var container:Sprite;
		private var timer:Timer;
		
		public function Shaker(container:Sprite) {
			this.container = container;
			timer = new Timer(20, 15);
			timer.addEventListener(TimerEvent.TIMER, shakeImage);
			timer.addEventListener(TimerEvent.TIMER_COMPLETE, onComplete);
		}
		
		private function onComplete(e:TimerEvent):void {
			timer.stop();
			container.x = 0;
			container.y = 0;
			container.rotation = 0;
		}
		
		private function shakeImage(e:TimerEvent):void {
			container.x = getMinusOrPlus() * (Math.random() * 5);
			container.y = getMinusOrPlus() * (Math.random() * 5);
			container.rotation = 0.2 *getMinusOrPlus() * Math.random() * 2;
		}
		
		private function getMinusOrPlus():int {
			var rand:Number = Math.random() * 2;
			if (rand < 1) {
				return -1
			} else {
				return 1;
			}
			return 0;
		}
		
		public function shake():void {
			onComplete(null);
			timer.reset();
			timer.start();
		}
	}
}