package com.geekparty.shooter.view.components {
	import com.geekparty.shooter.Main;
	import flash.display.*;
	import flash.events.Event;
	import flash.net.URLRequest;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class ScrollingLayer extends Sprite {
		
		private var source:BitmapData;
		private var layer_1:Bitmap;
		private var layer_2:Bitmap;
		private var layer_3:Bitmap;
		private var loader:Loader;
		
		public function ScrollingLayer() {
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
		}
		
		public function init(scroll_speed:int, asset:Class):void {
			this.scroll_speed = scroll_speed;
			onLoaded(asset);
			//loader.load(new URLRequest(asset));
		}
		
		private function onLoaded(asset:Class):void {
			source = new asset().bitmapData;
			layer_1 = new Bitmap(source);
			layer_2 = new Bitmap(source);
			layer_3 = new Bitmap(source);
			addChild(layer_1);
			addChild(layer_2);
			addChild(layer_3);
			layer_2.x = layer_1.width;
			layer_3.x = layer_2.x +layer_2.width;
			loaded = true;
			
			layers = new <Bitmap>[
				layer_1
				,	layer_2
				,	layer_3
			];
		}
		
		private var layers:Vector.<Bitmap>;
		
		private var scroll_speed:int;
		private var loaded:Boolean;
		
		public function move():void {
			if (!loaded) {
				return;
			}		
			var i:int;
			for (i = 0; i < layers.length; i++) {
				layers[i].x -= scroll_speed;
			}
			
			if (layers[0].x <= - layers[0].width) {
				layers[0].x = layers[2].x + layers[2].width;
				layers.push(layers.shift());
			}
		}
	}
}