package com.geekparty.shooter.core.managers {
	import com.geekparty.shooter.view.screens.*;
	import com.geekparty.shooter.view.*;
	import com.geekparty.shooter.*;
	import flash.display.*;
	/**
	 * ...
	 * @author Frost
	 */
	public class ScreenManager {
		
		private static var _inst:ScreenManager;
		
		public static function get instance():ScreenManager {
			if (_inst == null) {
				_inst = new ScreenManager();
			}
			return _inst;
		}
		
		private var screens:Vector.<Screen>;
		
		public var currentScreen:Screen;
		
		private var screenContainer:Sprite;
		
		public function ScreenManager() {
			screenContainer = Main.instance.layers.screenLayer;
			screens = new <Screen>[
				new Splash()
				,	new MainMenu()
				,	new Options()
				,	new Game()
			];
		}
		
		public function changeScreen(screenType:int):void {
			if (currentScreen != null) {
				if (currentScreen.type == screenType) {
					return; 
				}
				currentScreen.hide();
				screenContainer.removeChild(currentScreen);
			}
			currentScreen = getScreenByType(screenType);
			screenContainer.addChild(currentScreen);
			currentScreen.show();
		}
		
		private function getScreenByType(screenType:int):Screen {
			var i:int;
			for (i = 0; i < screens.length; i++) {
				if (screens[i].type == screenType) {
					return screens[i];
				}
			}
			throw new Error('ScreenManager: screen not found!');
			return null;
		}
	}

}