function Particles() {
    this.canvas = newCanvas(document.getElementById("content"), width, height, 500);
    this.context = this.canvas.getContext('2d');

    this.particles = [];

    this.proceed = function() {
        var parts = this.particles;
        var len = parts.length;
        while (len--) {
            var p = parts[len]
            p.proceed(parts);
            if (!onScreen(p.position)) {
                parts.splice(len, 1);
            }
        }
    }

    this.addParticle = function(particle) {
        particle.index = this.particles.length;
        this.particles.push(particle);
    }

    this.removeParticle = function(bullet) {
        var index = this.particles.indexOf(bullet);
        if (index !== -1) {
            this.particles.splice(index, 1);
        }
    }

    this.intersect = function(rect, owner) {
        var p = this.particles;
        for (var i = 0; i < p.length; i++) {
            if (p[i].owner !== owner && intersect(p[i].getBounds(), rect)) {
                return p[i];
            }
        }
        return null;
    }

    this.repaint = function() {
        this.canvas.width = this.canvas.width;
        var parts = this.particles;
        for (var i = 0; i < parts.length; i++) {
            parts[i].repaint(this.context);
        }
    }
}
