function Geom() {

    this.v = function(x, y, z) {
        return {x: x, y: y, z: z};
    };

    this.length = function(x, y, z) {
        if (arguments.length === 1) {
            return Math.sqrt(x.x * x.x + x.y * x.y + x.z * x.z);
        }
        return Math.sqrt(x * x + y * y + z * z);
    };

    this.add = function(a, b) {
        return {
            x: a.x + b.x,
            y: a.y + b.y,
            z: a.z + b.z
        };
    };

    this.sub = function(a, b) {
        return {
            x: a.x - b.x,
            y: a.y - b.y,
            z: a.z - b.z
        };
    };

    this.scal = function(a, k) {
        return {x: a.x * k, y: a.y * k, z: a.z * k};
    };
    this.norm = function(a) {
        var l = this.length(a.x, a.y, a.z);
        return {
            x: a.x / l, y: a.y / l, z: a.z / l
        };
    };
}

(function() {
    geom = new Geom();
})();

function newSphere(pos, r) {
    var radius = r, segments = 64, rings = 64;
    var sphereMaterial =
            new THREE.MeshLambertMaterial({
        color: 0xFF,
        //map: THREE.ImageUtils.loadTexture("img/clouds.png")
    });
    var sphere = new THREE.Mesh(new THREE.SphereGeometry(radius, segments, rings), sphereMaterial);
    sphere.position = pos;
    return sphere;
}

function generateParticleSphere(pos, r, count) {
    var particles = [];
    var d = 2 * r;
    for (var i = 0; i < count; i++) {
        var alpha = 2 * Math.PI * Math.random();
        var mR = Math.random();
        var pX = mR * Math.cos(alpha);
        var pY = mR * Math.sin(alpha);
        var pZ = Math.log(Math.sqrt(pX * pX + pY * pY));//pos.z + Math.random() * d - r;

        particle = new THREE.Vector3(d * pX + pos.x,
                d * pY + pos.y,
                d * pZ + pos.z);
        particle.alpha = alpha;
        particle.pos = pos;
        particle.r = mR * d;
        particle.d = d;
        particles.push(particle);
    }
    return particles;
}

$(function() {
    var WIDTH = 800;
    var HEIGHT = 600;

// set some camera attributes
    var VIEW_ANGLE = 45;
    var ASPECT = WIDTH / HEIGHT;
    var NEAR = 0.1;
    var FAR = 1000;
    var radius = 200;

    var $container = $('#content');
    var renderer = new THREE.WebGLRenderer();
    var camera = new THREE.PerspectiveCamera(VIEW_ANGLE, ASPECT, NEAR, FAR);

    var scene = new THREE.Scene();
    scene.add(camera);
    camera.position.z = 300;
    renderer.setSize(WIDTH, HEIGHT);
    $container.append(renderer.domElement);

    var particleCount = 60;
    var particles = new THREE.Geometry();
    var pMaterial = new THREE.ParticleBasicMaterial({
        color: 0xABCDEF,
        //map: THREE.ImageUtils.loadTexture("img/clouds.png"),
        size: 2
    });


    particles.vertices = generateParticleSphere(geom.v(0, 0, 0), 50, 5000);

    var particleSystem = new THREE.ParticleSystem(particles, pMaterial);
    var pointLight = new THREE.PointLight(0xFFFFFF);

// set its position
    pointLight.position.x = 10;
    pointLight.position.y = 50;
    pointLight.position.z = 130;

    var testSphere = newSphere(geom.v(0, 0, 0), 2);

    camera.position.y = 0;
    camera.position.z = 100;
    camera.alpha = 0;

    scene.add(particleSystem);
    // scene.add(testSphere);
    scene.add(pointLight);
    particleSystem.sortParticles = true;
    //particleSystem.rotation.y = Math.PI/2;
    setInterval(function() {

        for (var i = 0; i < particleCount; i++) {
            var a = particles.vertices[i];
            var v = geom.v(0, 0, 0);
            for (var j = 0; j < particleCount; j++) {
                if (i !== j) {
                    var b = particles.vertices[j];
                    /*   var delta = geom.sub(b, a);
                     var l = geom.length(delta);
                     v = geom.add(v, geom.scal(geom.norm(delta), 0.001));*/
                }
            }
            a.velocity = v;
        }
        // particleSystem.rotation.y += 0.001;
        for (var i = 0; i < particles.vertices.length; i++) {
            var p = particles.vertices[i];
            p.alpha += 0.001;
            p.r -= 0.01;
            if (p.r < 0) {
                p.r = p.d;
            }
            p.x = p.pos.x + p.r * Math.cos(p.alpha);//v.x;
            p.y = p.pos.y + p.r * Math.sin(p.alpha);
            p.z = -100 / Math.sqrt(p.x * p.x + p.y * p.y);
            //p.z += v.z;

        }
        particleSystem.geometry.__dirtyVertices = true;
        renderer.render(scene, camera);
    }, 1);
});