/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLRunnableTask;

public class GLDrawableHelper {
    private static final boolean PERF_STATS = Debug.isPropertyDefined("jogl.debug.GLDrawable.PerfStats", true);
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    private final Object listenersLock = new Object();
    private final ArrayList<GLEventListener> listeners = new ArrayList();
    private final HashSet<GLEventListener> listenersToBeInit = new HashSet();
    private final Object glRunnablesLock = new Object();
    private volatile ArrayList<GLRunnableTask> glRunnables = new ArrayList();
    private boolean autoSwapBufferMode;
    private volatile Thread exclusiveContextThread;
    private volatile int exclusiveContextSwitch;
    private GLAnimatorControl animatorCtrl;
    private static Runnable nop = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final ThreadLocal<Runnable> perThreadInitAction = new ThreadLocal();

    public GLDrawableHelper() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.clear();
            this.listenersToBeInit.clear();
        }
        this.autoSwapBufferMode = true;
        this.exclusiveContextThread = null;
        this.exclusiveContextSwitch = 0;
        object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnables.clear();
        }
        this.animatorCtrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GLAnimatorControl: " + this.animatorCtrl + ", ");
        Object object = this.listenersLock;
        synchronized (object) {
            stringBuilder.append("GLEventListeners num " + this.listeners.size() + " [");
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = this.listeners.get(i);
                stringBuilder.append(gLEventListener);
                stringBuilder.append("[init ");
                stringBuilder.append(!this.listenersToBeInit.contains(gLEventListener));
                stringBuilder.append("], ");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final void forceNativeRelease(GLContext gLContext) {
        do {
            gLContext.release();
            if (!DEBUG) continue;
            System.err.println("GLDrawableHelper.forceNativeRelease() -- currentThread " + Thread.currentThread() + " -> " + GLContext.getCurrent());
        } while (gLContext == GLContext.getCurrent());
    }

    public static final boolean switchContext(GLDrawable gLDrawable, GLContext gLContext, GLContext gLContext2, int n) {
        boolean bl;
        if (null != gLContext) {
            if (gLContext.isCurrent()) {
                gLContext.release();
            }
            gLContext.setGLDrawable(null, true);
        }
        if (null != gLContext2) {
            bl = gLContext2.isCurrent();
            if (bl) {
                gLContext2.release();
            }
            gLContext2.setContextCreationFlags(n);
            gLContext2.setGLDrawable(gLDrawable, true);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl recreateGLDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        ProxySurface proxySurface;
        if (!gLDrawableImpl.isRealized()) {
            return gLDrawableImpl;
        }
        GLContext gLContext2 = GLContext.getCurrent();
        GLDrawableFactory gLDrawableFactory = gLDrawableImpl.getFactory();
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        ProxySurface proxySurface2 = proxySurface = nativeSurface instanceof ProxySurface ? (ProxySurface)nativeSurface : null;
        if (null != gLContext) {
            if (gLContext2 != gLContext) {
                gLContext.makeCurrent();
            }
            gLContext.getGL().glFinish();
            gLContext.release();
            gLContext.setGLDrawable(null, true);
        }
        if (null != proxySurface) {
            proxySurface.enableUpstreamSurfaceHookLifecycle(false);
        }
        try {
            gLDrawableImpl.setRealized(false);
            gLDrawableImpl = (GLDrawableImpl)gLDrawableFactory.createGLDrawable(nativeSurface);
            gLDrawableImpl.setRealized(true);
        }
        finally {
            if (null != proxySurface) {
                proxySurface.enableUpstreamSurfaceHookLifecycle(true);
            }
        }
        if (null != gLContext) {
            gLContext.setGLDrawable(gLDrawableImpl, true);
        }
        if (null != gLContext2) {
            gLContext2.makeCurrent();
        }
        return gLDrawableImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl resizeOffscreenDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext, int n, int n2) throws NativeWindowException, GLException {
        if (gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
            throw new NativeWindowException("Drawable is not offscreen: " + gLDrawableImpl);
        }
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        int n3 = nativeSurface.lockSurface();
        if (1 >= n3) {
            throw new NativeWindowException("Could not lock surface of drawable: " + gLDrawableImpl);
        }
        boolean bl = true;
        try {
            if (DEBUG && (0 >= n || 0 >= n2)) {
                System.err.println("WARNING: Odd size detected: " + n + "x" + n2 + ", using safe size 1x1. Drawable " + gLDrawableImpl);
                Thread.dumpStack();
            }
            if (0 >= n) {
                n = 1;
                bl = false;
            }
            if (0 >= n2) {
                n2 = 1;
                bl = false;
            }
            if (nativeSurface instanceof ProxySurface) {
                ProxySurface proxySurface = (ProxySurface)nativeSurface;
                UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
                if (upstreamSurfaceHook instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSize(n, n2);
                } else if (DEBUG) {
                    System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen ProxySurface n.a. UpstreamSurfaceHook.MutableSize, but " + upstreamSurfaceHook.getClass().getName() + ": " + upstreamSurfaceHook);
                }
            } else if (DEBUG) {
                System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen surface n.a. ProxySurface, but " + nativeSurface.getClass().getName() + ": " + nativeSurface);
            }
            if (gLDrawableImpl instanceof GLFBODrawable) {
                if (null != gLContext && gLContext.isCreated()) {
                    ((GLFBODrawable)((Object)gLDrawableImpl)).resetSize(gLContext.getGL());
                }
            } else {
                gLDrawableImpl = GLDrawableHelper.recreateGLDrawable(gLDrawableImpl, gLContext);
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
        if (bl && (gLDrawableImpl.getWidth() != n || gLDrawableImpl.getHeight() != n2)) {
            throw new InternalError("Incomplete resize operation: expected " + n + "x" + n2 + ", has: " + gLDrawableImpl);
        }
        return gLDrawableImpl;
    }

    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.addGLEventListener(-1, gLEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGLEventListener(int n, GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size();
            }
            this.listenersToBeInit.add(gLEventListener);
            this.listeners.add(n, gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersToBeInit.remove(gLEventListener);
            return this.listeners.remove(gLEventListener) ? gLEventListener : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(int n) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size() - 1;
            }
            GLEventListener gLEventListener = this.listeners.remove(n);
            this.listenersToBeInit.remove(gLEventListener);
            return gLEventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getGLEventListenerCount() {
        Object object = this.listenersLock;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size() - 1;
            }
            return this.listeners.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            return !this.listenersToBeInit.contains(gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                this.listenersToBeInit.remove(gLEventListener);
            } else {
                this.listenersToBeInit.add(gLEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener disposeGLEventListener(GLAutoDrawable gLAutoDrawable, GLEventListener gLEventListener, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                if (this.listeners.remove(gLEventListener)) {
                    if (!this.listenersToBeInit.remove(gLEventListener)) {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    return gLEventListener;
                }
            } else if (this.listeners.contains(gLEventListener) && !this.listenersToBeInit.contains(gLEventListener)) {
                gLEventListener.dispose(gLAutoDrawable);
                this.listenersToBeInit.add(gLEventListener);
                return gLEventListener;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int disposeAllGLEventListener(GLAutoDrawable gLAutoDrawable, boolean bl) {
        int n = 0;
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                for (int i = this.listeners.size(); 0 < i && 0 < this.listeners.size(); --i) {
                    GLEventListener gLEventListener = this.listeners.remove(0);
                    if (this.listenersToBeInit.remove(gLEventListener)) continue;
                    gLEventListener.dispose(gLAutoDrawable);
                    ++n;
                }
            } else {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    GLEventListener gLEventListener = this.listeners.get(i);
                    if (this.listenersToBeInit.contains(gLEventListener)) continue;
                    gLEventListener.dispose(gLAutoDrawable);
                    this.listenersToBeInit.add(gLEventListener);
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener disposeGLEventListener(final GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, final GLEventListener gLEventListener, final boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listenersToBeInit.contains(gLEventListener)) {
                if (bl) {
                    this.listenersToBeInit.remove(gLEventListener);
                    return this.listeners.remove(gLEventListener) ? gLEventListener : null;
                }
                return null;
            }
        }
        boolean bl2 = this.isAnimatorAnimatingOnOtherThread() && this.animatorCtrl.pause();
        final GLEventListener[] gLEventListenerArray = new GLEventListener[]{null};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                gLEventListenerArray[0] = GLDrawableHelper.this.disposeGLEventListener(gLAutoDrawable, gLEventListener, bl);
            }
        };
        this.invokeGL(gLDrawable, gLContext, runnable, nop);
        if (bl2) {
            this.animatorCtrl.resume();
        }
        return gLEventListenerArray[0];
    }

    public final void disposeAllGLEventListener(final GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, final boolean bl) {
        boolean bl2 = this.isAnimatorAnimatingOnOtherThread() && this.animatorCtrl.pause();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GLDrawableHelper.this.disposeAllGLEventListener(gLAutoDrawable, bl);
            }
        };
        this.invokeGL(gLDrawable, gLContext, runnable, nop);
        if (bl2) {
            this.animatorCtrl.resume();
        }
    }

    private final void init(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, boolean bl) {
        gLEventListener.init(gLAutoDrawable);
        if (bl) {
            this.reshape(gLEventListener, gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                GLEventListener gLEventListener = arrayList.get(i);
                this.listenersToBeInit.remove(gLEventListener);
                this.init(gLEventListener, gLAutoDrawable, bl);
            }
        }
    }

    public final void display(GLAutoDrawable gLAutoDrawable) {
        this.displayImpl(gLAutoDrawable);
        if (!this.execGLRunnables(gLAutoDrawable)) {
            this.displayImpl(gLAutoDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void displayImpl(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                GLEventListener gLEventListener = arrayList.get(i);
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, true);
                }
                gLEventListener.display(gLAutoDrawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reshape(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (bl2) {
            Object object = this.listenersLock;
            synchronized (object) {
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, false);
                }
            }
        }
        if (bl) {
            gLAutoDrawable.getGL().glViewport(n, n2, n3, n4);
        }
        gLEventListener.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.reshape(this.listeners.get(i), gLAutoDrawable, n, n2, n3, n4, 0 == i, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean execGLRunnables(GLAutoDrawable gLAutoDrawable) {
        boolean bl = true;
        if (this.glRunnables.size() > 0) {
            ArrayList<GLRunnableTask> arrayList;
            Object object = this.glRunnablesLock;
            synchronized (object) {
                if (this.glRunnables.size() > 0) {
                    arrayList = this.glRunnables;
                    this.glRunnables = new ArrayList();
                } else {
                    arrayList = null;
                }
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    bl = arrayList.get(i).run(gLAutoDrawable) && bl;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushGLRunnables() {
        if (this.glRunnables.size() > 0) {
            ArrayList<GLRunnableTask> arrayList;
            Object object = this.glRunnablesLock;
            synchronized (object) {
                if (this.glRunnables.size() > 0) {
                    arrayList = this.glRunnables;
                    this.glRunnables = new ArrayList();
                } else {
                    arrayList = null;
                }
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.animatorCtrl != gLAnimatorControl && null != gLAnimatorControl && null != this.animatorCtrl) {
                throw new GLException("Trying to register GLAnimatorControl " + gLAnimatorControl + ", where " + this.animatorCtrl + " is already registered. Unregister first.");
            }
            this.animatorCtrl = gLAnimatorControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLAnimatorControl getAnimator() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            return this.animatorCtrl;
        }
    }

    public final boolean isAnimatorStartedOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorStarted() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() : false;
    }

    public final boolean isAnimatorAnimatingOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, GLRunnable gLRunnable) {
        if (null == gLRunnable || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        GLRunnableTask gLRunnableTask = null;
        Object object = new Object();
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                bl2 = this.isAnimatorAnimatingOnOtherThread();
                if (!bl2) {
                    bl = false;
                }
                gLRunnableTask = new GLRunnableTask(gLRunnable, bl ? object : null, bl);
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, List<GLRunnable> list) {
        if (null == list || list.size() == 0 || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        int n = list.size();
        GLRunnableTask gLRunnableTask = null;
        Object object = new Object();
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                boolean bl3 = bl2 = this.isAnimatorAnimatingOnOtherThread() || !gLAutoDrawable.isRealized();
                if (!bl2) {
                    bl = false;
                }
                for (int i = 0; i < n - 1; ++i) {
                    this.glRunnables.add(new GLRunnableTask(list.get(i), null, false));
                }
                gLRunnableTask = new GLRunnableTask(list.get(n - 1), bl ? object : null, bl);
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(GLRunnable gLRunnable) {
        if (null == gLRunnable) {
            return;
        }
        Object object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnables.add(new GLRunnableTask(gLRunnable, null, false));
        }
    }

    public final void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public final boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    private final String getExclusiveContextSwitchString() {
        return 0 == this.exclusiveContextSwitch ? "nop" : (0 > this.exclusiveContextSwitch ? "released" : "claimed");
    }

    public final Thread setExclusiveContextThread(Thread thread, GLContext gLContext) throws GLException {
        if (DEBUG) {
            System.err.println("GLDrawableHelper.setExclusiveContextThread(): START switch " + this.getExclusiveContextSwitchString() + ", thread " + this.exclusiveContextThread + " -> " + thread + " -- currentThread " + Thread.currentThread());
        }
        Thread thread2 = this.exclusiveContextThread;
        if (this.exclusiveContextThread == thread) {
            this.exclusiveContextSwitch = 0;
        } else if (null == thread) {
            this.exclusiveContextSwitch = -1;
        } else {
            this.exclusiveContextSwitch = 1;
            if (null != this.exclusiveContextThread) {
                throw new GLException("Release current exclusive Context Thread " + this.exclusiveContextThread + " first");
            }
            if (null != gLContext && GLContext.getCurrent() == gLContext) {
                try {
                    GLDrawableHelper.forceNativeRelease(gLContext);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new GLException(throwable);
                }
            }
            this.exclusiveContextThread = thread;
        }
        if (DEBUG) {
            System.err.println("GLDrawableHelper.setExclusiveContextThread(): END switch " + this.getExclusiveContextSwitchString() + ", thread " + this.exclusiveContextThread + " -- currentThread " + Thread.currentThread());
        }
        return thread2;
    }

    public final Thread getExclusiveContextThread() {
        return this.exclusiveContextThread;
    }

    public final void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        if (null == gLContext) {
            if (DEBUG) {
                GLException gLException = new GLException(Thread.currentThread().getName() + " Info: GLDrawableHelper " + this + ".invokeGL(): NULL GLContext");
                gLException.printStackTrace();
            }
            return;
        }
        if (PERF_STATS) {
            this.invokeGLImplStats(gLDrawable, gLContext, runnable, runnable2);
        } else {
            this.invokeGLImpl(gLDrawable, gLContext, runnable, runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeGL(GLAutoDrawable gLAutoDrawable, GLContext gLContext, boolean bl) {
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable = null;
        if (gLContext2 != null) {
            if (gLContext2 == gLContext) {
                gLContext2 = null;
            } else {
                runnable = perThreadInitAction.get();
                gLContext2.release();
            }
        }
        try {
            int n = gLContext.makeCurrent();
            if (0 != n) {
                if (2 == n) {
                    throw new GLException(Thread.currentThread().getName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context was not created (new ctx): " + gLContext);
                }
                if (this.listeners.size() > 0 && null != gLAutoDrawable) {
                    this.disposeAllGLEventListener(gLAutoDrawable, false);
                }
            }
        }
        finally {
            try {
                if (bl) {
                    gLContext.destroy();
                } else {
                    GLDrawableHelper.forceNativeRelease(gLContext);
                }
                this.flushGLRunnables();
            }
            catch (Exception exception) {
                System.err.println("Catched: " + exception.getMessage());
                exception.printStackTrace();
            }
            if (gLContext2 != null) {
                int n = gLContext2.makeCurrent();
                if (null != runnable && n == 2) {
                    runnable.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeGLImpl(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        int n;
        boolean bl;
        int n2;
        Thread thread = Thread.currentThread();
        if (null != this.exclusiveContextThread) {
            if (thread != this.exclusiveContextThread) return;
            n2 = 0 > this.exclusiveContextSwitch ? 1 : 0;
            bl = n2 == 0;
            this.exclusiveContextSwitch = 0;
        } else {
            n2 = 0;
            bl = false;
        }
        int n3 = 0;
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable3 = null;
        if (gLContext2 != null) {
            if (gLContext2 == gLContext) {
                n3 = 1;
                gLContext2 = null;
            } else {
                runnable3 = perThreadInitAction.get();
                gLContext2.release();
            }
        }
        try {
            if (0 == n3) {
                n3 = gLContext.makeCurrent();
                n = !bl ? 1 : 0;
            } else {
                n = n2;
            }
            if (0 == n3) return;
            try {
                perThreadInitAction.set(runnable2);
                if (2 == n3) {
                    if (DEBUG) {
                        System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                    }
                    runnable2.run();
                }
                runnable.run();
                if (!this.autoSwapBufferMode) return;
                gLDrawable.swapBuffers();
                return;
            }
            finally {
                if (n2 != 0) {
                    this.exclusiveContextThread = null;
                    if (DEBUG) {
                        System.err.println("GLDrawableHelper.invokeGL() - Release ExclusiveContextThread -- currentThread " + Thread.currentThread());
                    }
                }
                if (n != 0) {
                    try {
                        gLContext.release();
                    }
                    catch (Exception exception) {
                        System.err.println("Catched: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (gLContext2 != null) {
                n = gLContext2.makeCurrent();
                if (null != runnable3 && n == 2) {
                    runnable3.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeGLImplStats(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        block25: {
            int n;
            boolean bl4;
            int n2;
            Thread thread = Thread.currentThread();
            if (null != this.exclusiveContextThread) {
                if (thread != this.exclusiveContextThread) return;
                n2 = 0 > this.exclusiveContextSwitch ? 1 : 0;
                bl4 = n2 == 0;
            } else {
                n2 = 0;
                bl4 = false;
            }
            int n3 = 0;
            GLContext gLContext2 = GLContext.getCurrent();
            Runnable runnable3 = null;
            if (gLContext2 != null) {
                if (gLContext2 == gLContext) {
                    n3 = 1;
                    gLContext2 = null;
                } else {
                    runnable3 = perThreadInitAction.get();
                    gLContext2.release();
                }
            }
            l5 = System.currentTimeMillis();
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
            l = 0L;
            bl3 = false;
            bl2 = false;
            bl = false;
            try {
                if (0 == n3) {
                    n3 = gLContext.makeCurrent();
                    n = !bl4 ? 1 : 0;
                    bl3 = true;
                } else {
                    n = n2;
                }
                if (0 == n3) break block25;
                try {
                    perThreadInitAction.set(runnable2);
                    if (2 == n3) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                    l3 = System.currentTimeMillis();
                    l4 = l3 - l5;
                    runnable.run();
                    l2 = System.currentTimeMillis();
                    l3 = l2 - l3;
                    if (this.autoSwapBufferMode) {
                        gLDrawable.swapBuffers();
                        l = System.currentTimeMillis();
                        l2 = l - l2;
                    }
                }
                finally {
                    if (n2 != 0) {
                        this.exclusiveContextSwitch = 0;
                        this.exclusiveContextThread = null;
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper.invokeGL() - Release ExclusiveContextThread -- currentThread " + Thread.currentThread());
                        }
                    }
                    if (n != 0) {
                        try {
                            gLContext.release();
                            bl2 = true;
                        }
                        catch (Exception exception) {
                            System.err.println("Catched: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            }
            finally {
                l = System.currentTimeMillis() - l;
                if (gLContext2 != null) {
                    n = gLContext2.makeCurrent();
                    if (null != runnable3 && n == 2) {
                        runnable3.run();
                    }
                }
            }
        }
        long l6 = System.currentTimeMillis() - l5;
        System.err.println("td0 " + l6 + "ms, fps " + 1.0 / ((double)l6 / 1000.0) + ", td-makeCurrent: " + l4 + "ms, td-render " + l3 + "ms, td-swap " + l2 + "ms, td-release " + l + "ms, ctx claimed: " + bl3 + ", ctx release: " + bl2 + ", ctx destroyed " + bl);
    }
}

