/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl.awt;

import java.awt.Graphics;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.awt.Java2D;
import jogamp.opengl.awt.Java2DGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;

public class MacOSXJava2DCGLContext
extends MacOSXCGLContext
implements Java2DGLContext {
    private Graphics graphics;

    MacOSXJava2DCGLContext(GLContext gLContext) {
        super(null, gLContext);
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (!Java2D.makeOGLContextCurrentOnSurface(this.graphics, this.contextHandle)) {
            throw new GLException("Error making context current");
        }
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) {
        long l = this.createImplPreset(gLContextImpl);
        long l2 = Java2D.createOGLContextOnSurface(this.graphics, l);
        if (l2 == 0L) {
            if (DEBUG) {
                System.err.println("Error creating current: " + this);
            }
            return false;
        }
        if (!Java2D.makeOGLContextCurrentOnSurface(this.graphics, this.contextHandle)) {
            Java2D.destroyOGLContext(l2);
            if (DEBUG) {
                System.err.println("Error making created context current: " + this);
            }
            return false;
        }
        this.setGLFunctionAvailability(true, 0, 0, 2, false);
        this.contextHandle = l2;
        return true;
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
        Java2D.destroyOGLContext(this.contextHandle);
    }

    @Override
    public void setOpenGLMode(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        if (gLBackendType != MacOSXCGLDrawable.GLBackendType.CGL) {
            throw new GLException("OpenGL mode switching not supported for Java2D GLContexts");
        }
        super.setOpenGLMode(gLBackendType);
    }
}

