# -*- coding: cp1252 -*-
'''
Created on 21 aug 2012

@author: Dan Torberg

Modul som innehller spel-loopen samt metoder som anvnds av den.

Metoder: 

load_resources()        laddar in resurser som anvnds av spelloopen. Bakgrunden, bakgrundsljudet, spelarobjekten, bilden fr topmenyn,
                        en samling fr spelobjekten, en font samt en pygame.time.Clock().
user_input()            anvnds fr att registrear anvndarinput.
spawn_zombie()          slumpar fram en typ av fiende och lgger till den i spelet.
display_unlock_message()kontollerar ifall ett meddelande om att shotgunen r upplst och visar meddelandet om s r fallet.
display_killcount()     ritar ut antal kills i topmenyn.
display_weapontab()     ritar ut vilka vapen som spelarna anvnder uppe i topmenyn.
adjust_spawnrate()      minskar tiden mellan att zombies genereras vartefter spelet fortlper.
reset_globals()         stter vrderna i globals till default.
game_over()             kontrollerar om kraven fr att spelaren frlorat har uppntts och avslutar spel-loopen om s r fallet.
run_game()              brjar med att anropa load_resourses() samt reset_globals() fr att sedan g in i spel-loopen. Avslutar med 
                        att stnga av musiken och brja spela den som spelas i menyn istllet.
'''
import pygame, sys, Globals, Player, Enemy, Message, random
from pygame.locals import * 

def load_resources():
    global background
    global p1
    global p2
    global sprites
    global top_bar
    global font
    global clock
    
    background = Globals.load_image('images/bg.png')
    background = background.convert()

    pygame.mixer.music.load('sounds/Andersson187 - New in Town 8bit.mp3')
    pygame.mixer.music.set_volume(0.4)
    pygame.mixer.music.play(-1)

    p1 = Player.Player1()
    sprites = pygame.sprite.LayeredUpdates()
    sprites.add(p1)
    if Globals.players == 2:
        p2 = Player.Player2()
        sprites.add(p2)

    top_bar = Globals.load_image('images/weapon_icon.png', -1)

    font = pygame.font.Font(None, 28)

    clock = pygame.time.Clock()

def user_input(events):
    for event in events:
        if event.type == QUIT:
            pygame.quit()
            sys.exit(0)
        elif event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                Globals.quit_game = True
            if not Globals.game_over:
                if event.key == K_SPACE:
                    p1.shoot(sprites)
                elif event.key == K_RCTRL:
                    if Globals.players == 2:
                        p2.shoot(sprites)
                else:
                    p1.keydown(event.key)
                    if Globals.players == 2:
                        p2.keydown(event.key)
        elif event.type == KEYUP and not Globals.game_over:
            p1.keyup(event.key)
            if Globals.players == 2:
                p2.keyup(event.key)
        else:
            pass
        
def spawn_zombie():
    kind = random.randint(1, 100)
    location = random.randint(120, 490)
    
    if kind <= 50:
        sprites.add(Enemy.Zombie(1024, location))
    elif kind <= 75 and kind > 50:
        sprites.add(Enemy.FastZombie(1024, location))
    elif kind > 75:
        sprites.add(Enemy.StrongZombie(1024, location))
        
def display_unlock_message(screen):
    if p1.kills == 25 and Globals.p1_msg == False:
        text = font.render("Player 1: Shotgun unlocked. Press '2' to equip", 2, (255,0,0))
        sprites.add(Message.Message(text ,10 ,screen.get_height()-15 - text.get_height() ,240))
        Globals.p1_msg = True
    if Globals.players == 2:
        if p2.kills == 25 and Globals.p2_msg == False:
            text = font.render("Player 2: Shotgun unlocked. Press '0' to equip", 2, (255,0,0))
            sprites.add(Message.Message(text ,screen.get_width()-10 -text.get_width() ,screen.get_height()-15 - text.get_height() ,240))
            Globals.p2_msg = True
        
def display_killcount(screen):
    text = font.render("P1 KillCount: " + str(p1.kills), 2, (255,0,0))
    screen.blit(text, (139, 10))
    
    if Globals.players == 2:
        text = font.render("P2 KillCount: " + str(p2.kills), 2, (255,0,0))
        screen.blit(text, (screen.get_width()-139-text.get_width() , 10))
    
        text = font.render("Total KillCount: " + str(Globals.total_kills), 2, (255,0,0))
        screen.blit(text, (screen.get_width()/2-text.get_width()/2 , 10))
    
def display_weapontab(screen):
    if p1.weapon == 0 and p1.kills > 24:
        screen.blit(top_bar, (10, 10), (0, 28, 118, 28))
    elif p1.weapon == 1 and p1.kills > 24:
        screen.blit(top_bar, (10, 10), (0, 56, 118, 28))
    else:
        screen.blit(top_bar, (10, 10), (0, 0, 118, 28))
    
    if Globals.players == 2:
        if p2.weapon == 0 and p2.kills > 24:
            screen.blit(top_bar, (screen.get_width()-10-top_bar.get_width(), 10), (0, 112, 118, 28))
        elif p2.weapon == 1 and p2.kills > 24:
            screen.blit(top_bar, (screen.get_width()-10-top_bar.get_width(), 10), (0, 140, 118, 28))
        else:
            screen.blit(top_bar, (screen.get_width()-10-top_bar.get_width(), 10), (0, 84, 118, 28))
        
def adjust_spawnrate():
    if Globals.players == 2:
        if Globals.total_kills == 50:
            Globals.spawn_rate = 90
        elif Globals.total_kills == 100:
            Globals.spawn_rate = 60
        elif Globals. total_kills == 150:
            Globals.spawn_rate = 30
    else:
        if Globals.total_kills == 0:
            Globals.spawn_rate == 150
        elif Globals.total_kills == 50:
            Globals.spawn_rate = 120
        elif Globals.total_kills == 100:
            Globals.spawn_rate = 90
        elif Globals. total_kills == 150:
            Globals.spawn_rate = 60
        elif Globals. total_kills == 200:
            Globals.spawn_rate = 30

def reset_globals():
    Globals.quit_game = False
    Globals.total_kills = 0
    Globals.p1_msg = False
    Globals.p2_msg = False
    Globals.frame = 0
    Globals.spawn_rate = 120
    Globals.game_over = False
    
def game_over():
    found = False  
    for sprite in sprites:
        if isinstance(sprite, Message.Message):
            found = True
    if found == False and Globals.game_over:
        Globals.quit_game = True
            
def run_game(screen):
    load_resources()
    reset_globals()
    
    while not Globals.quit_game:
        clock.tick(60)
    
        if Globals.frame == sys.maxint:
            Globals.frame = 0
        else:
            Globals.frame += 1
    
        adjust_spawnrate()
    
        if Globals.frame % Globals.spawn_rate == 0:
            spawn_zombie()
    
        user_input(pygame.event.get())
        sprites.update(sprites, screen)
        screen.blit(background, (0, 0))
    
        display_unlock_message(screen)
    
        display_killcount(screen)
    
        display_weapontab(screen)
    
        for sprite in sprites:
            sprite.draw(screen)
    
        pygame.display.flip()
        
        game_over()
    
    pygame.mixer.music.fadeout(2)
    pygame.mixer.music.load('sounds/JakesFable - Ecstatic Day.mp3')
    pygame.mixer.music.play(-1)
        
