# -*- coding: cp1252 -*-
'''
Created on 29 aug 2012

@author: Dan Torberg

Modul innehllande klasser fr att skapa knappar, det finns en basklass som har en update()-metod som uppdaterar objektet och registrerar 
ifall anvndaren "hovrar" ver knappen. Draw()-metoden ritar ut knappen p olika stt beroende p om anvndaren "hovrar ver knappen eller ej.
Modulen innehller ven klasser specifika fr min applikation som rver ifrn basklassen."
'''
import pygame, sys, Globals
from pygame.locals import *

class Button(pygame.sprite.Sprite):
    
    def __init__(self, x, y):
        pygame.sprite.Sprite.__init__(self)
        self.image = Globals.load_image('images/buttons.png',-1)
        self.rect = pygame.Rect((x, y), (193, 44))
        self.hasFocus = False
    
    def update(self):
        if self.rect.collidepoint(pygame.mouse.get_pos()):
            self.hasFocus = True
        else:
            self.hasFocus = False
    
    def draw(self, screen):
        screen.blit(self.image, self.rect)
        
class _1P(Button):
    
    def __init__(self, x, y):
        super(_1P, self).__init__(x, y)
    
    def draw(self, screen):
        if self.hasFocus:
            screen.blit(self.image, self.rect, (196, 1, 194, 46))
        else:
            screen.blit(self.image, self.rect, (1, 1, 194, 46))
        
class _2P(Button):
    
    def __init__(self, x, y):
        super(_2P, self).__init__(x, y)
    
    def draw(self, screen):
        if self.hasFocus:
            screen.blit(self.image, self.rect, (196, 47, 194, 46))
        else:
            screen.blit(self.image, self.rect, (1, 47, 194, 46))
        
class Credits(Button):
    
    def __init__(self, x, y):
        super(Credits, self).__init__(x, y)
    
    def draw(self, screen):
        if self.hasFocus:
            screen.blit(self.image, self.rect, (196, 141, 194, 46))
        else:
            screen.blit(self.image, self.rect, (1, 141, 194, 46))

class Instructions(Button):
    
    def __init__(self, x, y):
        super(Instructions, self).__init__(x, y)
    
    def draw(self, screen):
        if self.hasFocus:
            screen.blit(self.image, self.rect, (196, 94, 194, 46))
        else:
            screen.blit(self.image, self.rect, (1, 94, 194, 46))

class Quit(Button):
    
    def __init__(self, x, y):
        super(Quit, self).__init__(x, y)
    
    def draw(self, screen):
        if self.hasFocus:
            screen.blit(self.image, self.rect, (196, 235, 194, 46))
        else:
            screen.blit(self.image, self.rect, (1, 235, 194, 46))
            
class Back(Button):
    
    def __init__(self, x, y):
        super(Back, self).__init__(x, y)
    
    def draw(self, screen):
        if self.hasFocus:
            screen.blit(self.image, self.rect, (196, 188, 194, 46))
        else:
            screen.blit(self.image, self.rect, (1, 188, 194, 46))
