/*
 * Decompiled with CFR 0.152.
 */
package sound;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JOptionPane;
import sound.Sound;

class SoundFile {
    AudioFormat af;
    DataLine.Info info;
    byte[] audio;
    int size;
    static boolean soundErrorShown = false;

    public SoundFile(String path) {
        try {
            int newRead;
            URL u = Sound.class.getResource(path);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(u);
            this.af = audioInputStream.getFormat();
            this.size = (int)((long)this.af.getFrameSize() * audioInputStream.getFrameLength());
            this.audio = new byte[this.size];
            this.info = new DataLine.Info(Clip.class, this.af, this.size);
            int read = 0;
            while ((newRead = audioInputStream.read(this.audio, read, this.size)) != -1) {
                read += newRead;
            }
        }
        catch (Exception e) {
            if (!soundErrorShown) {
                soundErrorShown = true;
                JOptionPane.showMessageDialog(null, "Error loading sound");
            }
            e.printStackTrace();
        }
    }
}

