/*
 * Decompiled with CFR 0.152.
 */
package game;

import effects.EffectHandler;
import entities.projectiles.Projectile;
import entities.units.Builder;
import entities.units.Factory1;
import entities.units.HoverLight;
import entities.units.MissileTower;
import entities.units.ResMakerS;
import entities.units.TankLight;
import entities.units.Unit;
import entities.units.UnitType;
import entities.units.unitOrders.UnitAttackOrder;
import entities.units.unitOrders.UnitBuilderBuildOrder;
import entities.units.unitOrders.UnitFactoryBuildOrder;
import entities.units.unitOrders.UnitHelpBuildOrder;
import entities.units.unitOrders.UnitMoveOrder;
import entities.units.unitOrders.UnitOrder;
import game.Camera;
import game.Hud;
import game.Input;
import game.Package;
import game.Player;
import game.Settings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import maps.B23Map;
import maps.MapInfo;
import orders.AttackOrder;
import orders.BuilderBuildOrder;
import orders.FactoryBuildOrder;
import orders.FactoryRemoveBuildOrder;
import orders.HelpBuildOrder;
import orders.MoveOrder;
import orders.Order;
import orders.SpawnOrder;
import sound.Sound;
import utils.Rect;
import utils.Vec2;

public class Game {
    ArrayList<Unit> units = new ArrayList();
    ArrayList<Unit> selectedUnits = new ArrayList();
    ArrayList<Order> myOrders = new ArrayList();
    ArrayList<Projectile> projectiles = new ArrayList();
    public Input input;
    public int myPlayerID;
    Random simRand;
    Random localRand = new Random();
    int nextUnitID = 0;
    Camera camera;
    public B23Map map;
    ArrayList<Player> players = new ArrayList();
    static int startingResources = Settings.CHEAT_HIGH_START_RESOURCES ? 1000000 : 1000;
    private boolean initDone = false;
    private Hud hud;
    public UnitType currentBuildType;
    public int simulationNumber = 0;
    public EffectHandler effectHandler;
    public Sound sound;
    private Point selectionRectStart;
    private Point selectionRectCurrent;
    private boolean makingSelectRect = false;

    public Game(int myPlayerID, Input input, long simRandSeed, JFrame frame, Sound sound) {
        this.myPlayerID = myPlayerID;
        this.input = input;
        this.sound = sound;
        this.simRand = new Random(simRandSeed);
        this.camera = new Camera(new Vec2(0.0, 0.0), frame);
        this.hud = new Hud(this, frame);
        this.effectHandler = new EffectHandler(sound);
    }

    public void initSimulation(Package.LobbyPlayerServerPackage[] lobbyPlayers, int mapNumber) {
        this.map = MapInfo.createMap(mapNumber, this);
        int i = 0;
        while (i < lobbyPlayers.length) {
            this.players.add(new Player(lobbyPlayers[i]));
            ++i;
        }
        this.units = new ArrayList();
        i = 0;
        while (i < this.players.size()) {
            if (this.players.get((int)i).playerID == this.myPlayerID) {
                this.camera.setPosCenter(this.map.getSpawnPoint(i));
            }
            this.units.add(new Builder(this, this.map.getSpawnPoint(i), this.players.get((int)i).playerID, this.nextUnitID(), null));
            ++i;
        }
        this.initDone = true;
    }

    public int nextUnitID() {
        ++this.nextUnitID;
        return this.nextUnitID;
    }

    public void simulate(ArrayList<Order[]> currentPlayerOrders) {
        int i = 0;
        while (i < currentPlayerOrders.size()) {
            if (currentPlayerOrders.get(i) != null) {
                int c = 0;
                while (c < currentPlayerOrders.get(i).length) {
                    Order order = currentPlayerOrders.get(i)[c];
                    this.simulateOrder(order);
                    ++c;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.units.size()) {
            this.units.get(i).simulate();
            ++i;
        }
        if (this.simulationNumber % 100 == 0) {
            i = 0;
            while (i < this.units.size()) {
                this.findPlayer((int)this.units.get((int)i).myPlayerID).resources += this.units.get(i).resourceMake();
                ++i;
            }
        }
        i = 0;
        while (i < this.projectiles.size()) {
            this.projectiles.get(i).simulate();
            ++i;
        }
        i = 0;
        while (i < this.units.size()) {
            if (this.units.get((int)i).shallBeRemoved) {
                this.units.get(i).finishBeforeRemove();
                this.units.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.projectiles.size()) {
            if (this.projectiles.get((int)i).shallBeRemoved) {
                this.projectiles.remove(i);
                --i;
            }
            ++i;
        }
        this.effectHandler.simulate();
        this.camera.update(this.input, this.map);
        ++this.simulationNumber;
    }

    private void simulateOrder(Order order) {
        if (order == null) {
            return;
        }
        if (order instanceof SpawnOrder) {
            SpawnOrder so = (SpawnOrder)order;
            this.units.add(new Builder(this, new Vec2(this.simRand.nextInt(1000), this.simRand.nextInt(1000)), so.playerID, this.nextUnitID(), null));
            this.units.add(new Factory1(this, new Vec2(this.simRand.nextInt(1000), this.simRand.nextInt(1000)), so.playerID, this.nextUnitID(), new UnitOrder[]{new UnitFactoryBuildOrder()}));
            this.units.add(new HoverLight(this, new Vec2(this.simRand.nextInt(1000), this.simRand.nextInt(1000)), so.playerID, this.nextUnitID(), null));
            this.units.add(new ResMakerS(this, new Vec2(this.simRand.nextInt(1000), this.simRand.nextInt(1000)), so.playerID, this.nextUnitID(), null));
            this.units.add(new TankLight(this, new Vec2(this.simRand.nextInt(1000), this.simRand.nextInt(1000)), so.playerID, this.nextUnitID(), null));
            this.units.add(new MissileTower(this, new Vec2(this.simRand.nextInt(1000), this.simRand.nextInt(1000)), so.playerID, this.nextUnitID(), null));
        } else if (order instanceof MoveOrder) {
            MoveOrder mo = (MoveOrder)order;
            int i = 0;
            while (i < mo.unitIDs.length) {
                Unit u = this.getUnit(mo.unitIDs[i]);
                if (u != null) {
                    if (mo.shift) {
                        u.addOrder(new UnitMoveOrder(mo.target));
                    } else {
                        u.addOrderAndErase(new UnitMoveOrder(mo.target));
                    }
                }
                ++i;
            }
        } else if (order instanceof AttackOrder) {
            AttackOrder ao = (AttackOrder)order;
            Unit target = this.getUnit(ao.targetUnitID);
            int i = 0;
            while (i < ao.unitIDs.length) {
                Unit u = this.getUnit(ao.unitIDs[i]);
                if (u != null) {
                    if (ao.shift) {
                        this.getUnit(ao.unitIDs[i]).addOrder(new UnitAttackOrder(target));
                    } else {
                        this.getUnit(ao.unitIDs[i]).addOrderAndErase(new UnitAttackOrder(target));
                    }
                }
                ++i;
            }
        } else if (order instanceof FactoryBuildOrder) {
            FactoryBuildOrder fbo = (FactoryBuildOrder)order;
            Unit factory = this.getUnit(fbo.unitID);
            if (factory == null) {
                return;
            }
            factory.factoryBuildAdd(fbo.buildListPos, fbo.number);
        } else if (order instanceof FactoryRemoveBuildOrder) {
            FactoryRemoveBuildOrder frbo = (FactoryRemoveBuildOrder)order;
            Unit factory = this.getUnit(frbo.unitID);
            if (factory == null) {
                return;
            }
            factory.factoryBuildRemove(frbo.buildListPos, frbo.number);
        } else if (order instanceof BuilderBuildOrder) {
            BuilderBuildOrder bbo = (BuilderBuildOrder)order;
            if (bbo.shift) {
                this.getUnit(bbo.unitID).addOrder(new UnitBuilderBuildOrder(bbo.target, bbo.buildListPos));
            } else {
                this.getUnit(bbo.unitID).addOrderAndErase(new UnitBuilderBuildOrder(bbo.target, bbo.buildListPos));
            }
        } else if (order instanceof HelpBuildOrder) {
            HelpBuildOrder hbo = (HelpBuildOrder)order;
            Unit target = this.getUnit(hbo.targetUnitID);
            int i = 0;
            while (i < hbo.unitIDs.length) {
                if (hbo.shift) {
                    this.getUnit(hbo.unitIDs[i]).addOrder(new UnitHelpBuildOrder(target));
                } else {
                    this.getUnit(hbo.unitIDs[i]).addOrderAndErase(new UnitHelpBuildOrder(target));
                }
                ++i;
            }
        } else {
            System.err.println("unkown order in simulate order: " + order);
        }
    }

    private Unit getUnit(int unitID) {
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get((int)i).unitID == unitID) {
                return this.units.get(i);
            }
            ++i;
        }
        System.err.println("getUnit kallades med id som ej fanns unitID: " + unitID);
        return null;
    }

    private Point botRightOf(Point p1, Point p2) {
        if (p1 == null || p2 == null) {
            return new Point(0, 0);
        }
        return new Point(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
    }

    private Point topLeftOf(Point p1, Point p2) {
        if (p1 == null || p2 == null) {
            return new Point(0, 0);
        }
        return new Point(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y));
    }

    public void update() {
        boolean mouseOnHud = this.hud.posOnHud(this.input.getMousePoint());
        if (!mouseOnHud) {
            if (this.input.isMouseRightPressed()) {
                this.handleRightClickGame();
            }
            if (this.input.isMouseLeftPressed()) {
                this.handleLeftClickGame();
            }
            if (this.input.isMouseLeftDown() && !this.makingSelectRect) {
                this.makingSelectRect = true;
                this.selectionRectStart = this.toWorldPos(this.input.getMousePoint());
            } else if (this.input.isMouseLeftDown() && this.makingSelectRect) {
                this.selectionRectCurrent = this.toWorldPos(this.input.getMousePoint());
            } else if (this.makingSelectRect) {
                this.selectUnits();
                this.selectionRectStart = null;
                this.selectionRectCurrent = null;
                this.makingSelectRect = false;
            }
        } else if (mouseOnHud) {
            this.hud.handleMouseOnHud(this.input);
        }
        this.checkBuildHotKeys();
        if (this.input.isKeyDown(this.input.CTRL) && this.input.isKeyPressed(this.input.A)) {
            this.selectAllUnits();
        }
        if (this.input.isKeyPressed(this.input.T)) {
            this.trackCamera();
        }
        this.input.isKeyPressed(this.input.S);
    }

    private void trackCamera() {
        if (this.selectedUnits == null || this.selectedUnits.size() == 0) {
            return;
        }
        int i = (int)(Math.random() * (double)this.selectedUnits.size());
        this.camera.track(this.selectedUnits.get(i));
    }

    private void selectAllUnits() {
        this.selectedUnits.clear();
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get((int)i).myPlayerID == this.myPlayerID) {
                this.selectedUnits.add(this.units.get(i));
            }
            ++i;
        }
    }

    private void checkBuildHotKeys() {
        boolean buildFound = false;
        if (this.selectedUnits.size() == 1 && this.selectedUnits.get(0).canBuild()) {
            if (this.selectedUnits.get(0).factoryBuilder()) {
                int i = 49;
                while (i <= 57) {
                    if (this.input.isKeyPressed(i) && this.selectedUnits.get((int)0).builds.length > i - 49) {
                        FactoryBuildOrder fbo = new FactoryBuildOrder();
                        fbo.buildListPos = i - 49;
                        fbo.number = this.input.isKeyDown(this.input.SHIFT) ? 5 : 1;
                        fbo.unitID = this.selectedUnits.get((int)0).unitID;
                        this.myOrders.add(fbo);
                        this.effectHandler.newBuildMenuEffect(this.hud.buildListX, this.hud.buildListY + this.hud.buildListSize * (i - 49), this.hud.buildListSize);
                        break;
                    }
                    ++i;
                }
            } else {
                buildFound = true;
                int i = 49;
                while (i <= 57) {
                    if (this.input.isKeyDown(i) && this.selectedUnits.get((int)0).builds.length > i - 49) {
                        this.currentBuildType = this.selectedUnits.get((int)0).builds[i - 49];
                        break;
                    }
                    ++i;
                }
            }
        }
        if (!buildFound) {
            this.currentBuildType = null;
        }
    }

    private Point toWorldPos(Point mousePos) {
        return new Point((int)(this.camera.pos.x + (double)mousePos.x), (int)(this.camera.pos.y + (double)mousePos.y));
    }

    private void handleLeftClickGame() {
        if (this.currentBuildType != null && this.canPlaceBuilding(this.toWorldPos(this.input.getMousePoint()), UnitType.getSize(this.currentBuildType), this.currentBuildType == UnitType.RES_EXTRACTOR)) {
            BuilderBuildOrder bbo = new BuilderBuildOrder();
            bbo.unitID = this.selectedUnits.get((int)0).unitID;
            bbo.buildListPos = this.selectedUnits.get(0).getBuildListPosOf(this.currentBuildType);
            bbo.target = new Vec2(this.toWorldPos(this.input.getMousePoint()));
            bbo.shift = this.input.isKeyDown(this.input.SHIFT);
            this.myOrders.add(bbo);
            this.effectHandler.newBuildRect(this.toWorldPos(this.input.getMousePoint()), UnitType.getSize(this.currentBuildType));
            if (!this.input.isKeyDown(this.input.SHIFT)) {
                this.currentBuildType = null;
            }
        }
    }

    private boolean canPlaceBuilding(Point worldPos, double size, boolean extractor) {
        Vec2 wp = new Vec2(worldPos);
        Rect rect = new Rect(wp.x - size / 2.0, wp.y - size / 2.0, size, size);
        double hs = size / 2.0;
        ArrayList<Vec2> corners = new ArrayList<Vec2>();
        corners.add(wp.translateClone(-hs, -hs));
        corners.add(wp.translateClone(-hs, hs));
        corners.add(wp.translateClone(hs, -hs));
        corners.add(wp.translateClone(hs, hs));
        corners.add(wp);
        for (Vec2 vec : corners) {
            B23Map.Type t = this.map.getType(vec);
            if (t != B23Map.Type.WATER) continue;
            return false;
        }
        ArrayList<Unit> units = this.map.getUnitsFromAdjecentTiles(wp);
        int i = 0;
        while (i < units.size()) {
            Rect r = units.get(i).getMyRect();
            if (r.intersects(rect) || rect.intersects(r)) {
                return false;
            }
            ++i;
        }
        if (extractor) {
            return this.map.onResource(rect);
        }
        return true;
    }

    private void handleRightClickGame() {
        if (this.currentBuildType != null && !this.input.isKeyDown(this.input.SHIFT)) {
            this.currentBuildType = null;
        } else {
            boolean unitOnClick = false;
            int i = 0;
            while (i < this.units.size()) {
                int c;
                int j;
                int applicables;
                Unit u = this.units.get(i);
                Point p = this.toWorldPos(this.input.getMousePoint());
                Rect r = new Rect(p.x, p.y, 1.0, 1.0);
                if (u.myPlayerID != this.myPlayerID && u.intersects(r)) {
                    applicables = 0;
                    int j2 = 0;
                    while (j2 < this.selectedUnits.size()) {
                        if (this.selectedUnits.get(j2).canAttack()) {
                            ++applicables;
                        }
                        ++j2;
                    }
                    AttackOrder ao = new AttackOrder();
                    ao.unitIDs = new int[applicables];
                    j = 0;
                    c = 0;
                    while (j < this.selectedUnits.size()) {
                        if (this.selectedUnits.get(j).canAttack()) {
                            ao.unitIDs[c] = this.selectedUnits.get((int)j).unitID;
                            ++c;
                        }
                        ++j;
                    }
                    ao.targetUnitID = u.unitID;
                    ao.shift = this.input.isKeyDown(this.input.SHIFT);
                    this.myOrders.add(ao);
                    unitOnClick = true;
                    break;
                }
                if (u.myPlayerID == this.myPlayerID && u.intersects(r) && !u.isFinishedBuilt()) {
                    applicables = 0;
                    int j3 = 0;
                    while (j3 < this.selectedUnits.size()) {
                        if (this.selectedUnits.get(j3).canBuild() && !this.selectedUnits.get(j3).factoryBuilder()) {
                            ++applicables;
                        }
                        ++j3;
                    }
                    HelpBuildOrder hbo = new HelpBuildOrder();
                    hbo.unitIDs = new int[applicables];
                    j = 0;
                    c = 0;
                    while (j < this.selectedUnits.size()) {
                        if (this.selectedUnits.get(j).canBuild() && !this.selectedUnits.get(j).factoryBuilder()) {
                            hbo.unitIDs[c] = this.selectedUnits.get((int)j).unitID;
                            ++c;
                        }
                        ++j;
                    }
                    hbo.targetUnitID = u.unitID;
                    hbo.shift = this.input.isKeyDown(this.input.SHIFT);
                    this.myOrders.add(hbo);
                    unitOnClick = true;
                    break;
                }
                ++i;
            }
            if (!unitOnClick) {
                MoveOrder mo = new MoveOrder();
                mo.unitIDs = new int[this.selectedUnits.size()];
                int i2 = 0;
                while (i2 < this.selectedUnits.size()) {
                    mo.unitIDs[i2] = this.selectedUnits.get((int)i2).unitID;
                    ++i2;
                }
                mo.target = new Vec2(this.toWorldPos(this.input.getMousePoint()));
                mo.shift = this.input.isKeyDown(this.input.SHIFT);
                this.myOrders.add(mo);
            }
        }
    }

    private void selectUnits() {
        if (!this.input.isKeyDown(this.input.SHIFT)) {
            this.selectedUnits.clear();
        }
        int i = 0;
        while (i < this.units.size()) {
            Unit u = this.units.get(i);
            Point topLeft = this.topLeftOf(this.selectionRectStart, this.selectionRectCurrent);
            Point botRight = this.botRightOf(this.selectionRectStart, this.selectionRectCurrent);
            Rect r = new Rect(topLeft.x, topLeft.y, botRight.x - topLeft.x, botRight.y - topLeft.y);
            if (u.myPlayerID == this.myPlayerID && u.intersects(r)) {
                this.selectedUnits.add(u);
            }
            ++i;
        }
    }

    public Order[] popOrders() {
        Order[] orderArr = new Order[this.myOrders.size()];
        int i = 0;
        while (i < this.myOrders.size()) {
            orderArr[i] = this.myOrders.get(i);
            ++i;
        }
        this.myOrders.clear();
        return orderArr;
    }

    public Color getPlayerColor(int playerID) {
        return new Color(this.findPlayer((int)playerID).color);
    }

    public Player findPlayer(int playerID) {
        int i = 0;
        while (i < this.players.size()) {
            if (this.players.get((int)i).playerID == playerID) {
                return this.players.get(i);
            }
            ++i;
        }
        System.err.println("could find player with id: " + playerID);
        return null;
    }

    public void draw(Graphics g) {
        if (!this.initDone) {
            return;
        }
        int camX = (int)this.camera.pos.x;
        int camY = (int)this.camera.pos.y;
        g.translate(-camX, -camY);
        this.map.draw(g);
        int i = 0;
        while (i < this.units.size()) {
            this.units.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.projectiles.size()) {
            this.projectiles.get(i).draw(g);
            ++i;
        }
        if (this.selectionRectStart != null && this.selectionRectCurrent != null) {
            g.setColor(Color.white);
            Point topLeft = this.topLeftOf(this.selectionRectStart, this.selectionRectCurrent);
            Point botRight = this.botRightOf(this.selectionRectStart, this.selectionRectCurrent);
            g.drawRect(topLeft.x, topLeft.y, botRight.x - topLeft.x, botRight.y - topLeft.y);
        }
        this.effectHandler.drawGame(g);
        g.translate(camX, camY);
        if (this.currentBuildType != null) {
            BufferedImage img = UnitType.getBuildPic(this.currentBuildType);
            int size = UnitType.getSize(this.currentBuildType);
            int h = (int)((double)size / 2.0);
            Point mp = this.input.getMousePoint();
            g.setColor(Color.red);
            g.drawRect(mp.x - h, mp.y - h, size, size);
            if (!this.canPlaceBuilding(this.toWorldPos(this.input.getMousePoint()), UnitType.getSize(this.currentBuildType), this.currentBuildType == UnitType.RES_EXTRACTOR)) {
                g.drawLine(mp.x - h, mp.y - h, mp.x + h, mp.y + h);
                g.drawLine(mp.x - h, mp.y + h, mp.x + h, mp.y - h);
            }
        }
        this.hud.draw(g);
        this.effectHandler.drawHud(g);
    }

    public void drawDebugInfo(Graphics g, int x, int y) {
        g.setColor(Color.white);
        g.drawString("Selected Units: " + this.selectedUnits.size(), x, y);
        g.drawString("Camera Pos: " + this.camera.pos.toString(), x, y + 20);
    }

    public boolean isSelected(Unit unit) {
        return this.selectedUnits.contains(unit);
    }

    public void addProjectile(Projectile projectile) {
        this.projectiles.add(projectile);
    }

    public void addUnit(Unit u) {
        this.units.add(u);
    }

    public static double angleFromTo(Vec2 from, Vec2 to) {
        double dx = to.x - from.x;
        double dy = to.y - from.y;
        return Math.atan2(dy, dx);
    }

    public int getResourceGain(int playerID) {
        int gain = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get((int)i).myPlayerID == playerID) {
                gain += this.units.get(i).resourceMake();
            }
            ++i;
        }
        return gain;
    }

    public int getSimulationNumber() {
        return this.simulationNumber;
    }

    public ArrayList<Unit> getUnits() {
        return this.units;
    }

    public boolean isCurrentBuildExtractor() {
        if (this.currentBuildType != null) {
            return this.currentBuildType == UnitType.RES_EXTRACTOR;
        }
        return false;
    }

    public ArrayList<Projectile> getProjectiles() {
        return this.projectiles;
    }

    public void addOrder(Order o) {
        this.myOrders.add(o);
    }

    public int gameOver() {
        if (Settings.DEBUG_START_GAME_ONE_PLAYER) {
            return -1;
        }
        int highestID = -1;
        int i = 0;
        while (i < this.players.size()) {
            highestID = Math.max(highestID, this.players.get((int)i).playerID);
            ++i;
        }
        boolean[] hasAnyUnits = new boolean[highestID + 1];
        int i2 = 0;
        while (i2 < this.units.size()) {
            hasAnyUnits[this.units.get((int)i2).myPlayerID] = true;
            ++i2;
        }
        int alivePlayers = 0;
        int i3 = 0;
        while (i3 < hasAnyUnits.length) {
            if (hasAnyUnits[i3]) {
                ++alivePlayers;
            }
            ++i3;
        }
        if (alivePlayers > 1) {
            return -1;
        }
        if (alivePlayers == 1) {
            i3 = 0;
            while (i3 < hasAnyUnits.length) {
                if (hasAnyUnits[i3]) {
                    return i3;
                }
                ++i3;
            }
        }
        System.err.println("0 alive players ");
        return -1337;
    }
}

