/*
 * Decompiled with CFR 0.152.
 */
package game;

import entities.Entity;
import game.Input;
import game.Settings;
import java.awt.Point;
import javax.swing.JFrame;
import maps.B23Map;
import utils.Vec2;

public class Camera {
    public Vec2 pos;
    private double speed = 15.0;
    private JFrame frame;
    private int panDis = 1;
    private Entity track;

    public Camera(Vec2 pos, JFrame frame) {
        this.pos = pos;
        this.frame = frame;
    }

    public void update(Input input, B23Map map) {
        if (this.track != null) {
            this.pos = this.track.pos.clone();
            this.pos.x -= (double)(this.frame.getWidth() / 2);
            this.pos.y -= (double)(this.frame.getHeight() / 2);
        }
        input.getClass();
        if (input.isKeyDown(37)) {
            this.pos.x -= this.speed;
            this.track = null;
        }
        input.getClass();
        if (input.isKeyDown(39)) {
            this.pos.x += this.speed;
            this.track = null;
        }
        input.getClass();
        if (input.isKeyDown(38)) {
            this.pos.y -= this.speed;
            this.track = null;
        }
        input.getClass();
        if (input.isKeyDown(40)) {
            this.pos.y += this.speed;
            this.track = null;
        }
        Point mp = input.getMousePoint();
        int w = this.frame.getWidth();
        int h = this.frame.getHeight();
        if (this.frame.isUndecorated()) {
            if (mp.x <= this.panDis) {
                this.pos.x -= this.speed;
                this.track = null;
            }
            if (mp.y <= this.panDis) {
                this.pos.y -= this.speed;
                this.track = null;
            }
            if (mp.x >= w - this.panDis) {
                this.pos.x += this.speed;
                this.track = null;
            }
            if (mp.y >= h - this.panDis) {
                this.pos.y += this.speed;
                this.track = null;
            }
        }
        if (!Settings.DEBUG_NO_CAMERA_BOUNDARIES) {
            this.moveIntoBoundraries(map);
        }
    }

    private void moveIntoBoundraries(B23Map map) {
        if (map == null) {
            return;
        }
        if (this.pos.x < 0.0) {
            this.pos.x = 0.0;
        }
        if (this.pos.y < 0.0) {
            this.pos.y = 0.0;
        }
        if (this.pos.x > (double)(map.getWidth() - this.frame.getWidth())) {
            this.pos.x = map.getWidth() - this.frame.getWidth();
        }
        if (this.pos.y > (double)(map.getHeight() - this.frame.getHeight())) {
            this.pos.y = map.getHeight() - this.frame.getHeight();
        }
    }

    public void track(Entity e) {
        this.track = e;
    }

    public void setPosCenter(Vec2 p) {
        this.pos = new Vec2(p.x - (double)(this.frame.getWidth() / 2), p.y - (double)(this.frame.getHeight() / 2));
    }
}

