/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;
import game.Input;
import game.Package;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import orders.Order;

public class B23Server
extends JPanel {
    private Server server;
    private int nextID = 0;
    private int simulationNum = 0;
    private boolean simulationRunning = false;
    private boolean gameStarted = false;
    private int players = 0;
    private int finishedPlayers = 0;
    private ArrayList<Order[]> playerOrders = new ArrayList();
    private Input input;
    private long simulationSeed;
    private boolean startPackageSent = false;
    private ArrayList<Package.LobbyPlayerServerPackage> lobbyPlayers = new ArrayList();
    private ArrayList<Connection> lobbyPlayersConnection = new ArrayList();
    private LinkedList<Color> freeColors = new LinkedList();
    private int MAX_TEAMS = 4;
    private LinkedList<Package.ChatMessage> unsentMessages = new LinkedList();
    private int map;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B23Server(boolean showFrame, int port) {
        this.simulationSeed = new Random().nextLong();
        this.addColors();
        this.initServer(port);
        if (showFrame) {
            this.initFrame();
        }
        long time = 0L;
        while (true) {
            if (showFrame) {
                this.input.update();
                this.repaint();
            }
            if (!this.gameStarted) {
                try {
                    this.server.sendToAllTCP(this.makeLobbyServerPackage(this.lobbyPlayers));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.finishedPlayers == this.players && this.simulationRunning) {
                Object e = this.lock;
                synchronized (e) {
                    Package.ServerPackage sp = new Package.ServerPackage();
                    sp.playerOrders = this.playerOrders;
                    try {
                        this.server.sendToAllTCP(sp);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    int i = 0;
                    while (i < this.playerOrders.size()) {
                        this.playerOrders.set(i, null);
                        ++i;
                    }
                    ++this.simulationNum;
                    this.finishedPlayers = 0;
                }
            }
            if (!this.startPackageSent && this.simulationRunning) {
                this.startPackageSent = true;
                Package.ServerPackage sp = new Package.ServerPackage();
                sp.playerOrders = this.playerOrders;
                try {
                    this.server.sendToAllTCP(sp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void startGame() {
        this.gameStarted = true;
        this.simulationRunning = !this.simulationRunning;
    }

    private Package.LobbyServerPackage makeLobbyServerPackage(ArrayList<Package.LobbyPlayerServerPackage> lpspArr) {
        Package.LobbyServerPackage lsp = new Package.LobbyServerPackage();
        lsp.map = this.map;
        lsp.newMessages = new Package.ChatMessage[this.unsentMessages.size()];
        int i = 0;
        while (!this.unsentMessages.isEmpty()) {
            lsp.newMessages[i] = this.unsentMessages.removeFirst();
            ++i;
        }
        lsp.players = new Package.LobbyPlayerServerPackage[lpspArr.size()];
        i = 0;
        while (i < lpspArr.size()) {
            lsp.players[i] = lpspArr.get(i);
            ++i;
        }
        return lsp;
    }

    private void addColors() {
        this.freeColors.add(Color.red);
        this.freeColors.add(Color.yellow);
        this.freeColors.add(Color.magenta);
        this.freeColors.add(Color.white);
        this.freeColors.add(Color.cyan);
        this.freeColors.add(Color.gray);
        this.freeColors.add(Color.pink);
    }

    private void initServer(int port) {
        this.server = new Server();
        Package.register(this.server);
        this.server.addListener(new Listener.ThreadedListener(new Listener(){

            @Override
            public void received(Connection c, Object object) {
                if (object instanceof Package.RequestServerInfo) {
                    Package.ServerInfo si = new Package.ServerInfo();
                    si.ip = "hejsan ip ska nog inte skickas h\u00e4r";
                    si.players = -1337;
                    c.sendTCP(si);
                } else {
                    B23Server.this.processClientPackage(object);
                }
            }

            @Override
            public void disconnected(Connection c) {
                int i = 0;
                while (i < B23Server.this.lobbyPlayersConnection.size()) {
                    if (B23Server.this.lobbyPlayersConnection.get(i) == c) {
                        B23Server.this.lobbyPlayersConnection.remove(i);
                        B23Server.this.freeColors.addLast(new Color(((Package.LobbyPlayerServerPackage)((B23Server)B23Server.this).lobbyPlayers.get((int)i)).color));
                        B23Server.this.lobbyPlayers.remove(i);
                        break;
                    }
                    ++i;
                }
                B23Server b23Server = B23Server.this;
                b23Server.players = b23Server.players - 1;
            }

            @Override
            public void connected(Connection c) {
                if (!B23Server.this.gameStarted) {
                    B23Server.this.lobbyPlayersConnection.add(c);
                    B23Server.this.lobbyPlayers.add(B23Server.this.nextLobbyServerPackage("NO_NAME"));
                    B23Server b23Server = B23Server.this;
                    b23Server.players = b23Server.players + 1;
                    B23Server.this.playerOrders.add(null);
                    Package.ConnectionPackage cp = new Package.ConnectionPackage();
                    cp.playerID = B23Server.this.nextID;
                    cp.simulationSeed = B23Server.this.simulationSeed;
                    B23Server b23Server2 = B23Server.this;
                    b23Server2.nextID = b23Server2.nextID + 1;
                    c.sendTCP(cp);
                } else if (B23Server.this.gameStarted) {
                    System.err.println("someone tried to connect after the game was started");
                }
            }
        }));
        this.server.start();
        try {
            this.server.bind(port, 54777);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Server error: " + e.getMessage());
        }
    }

    protected Package.LobbyPlayerServerPackage nextLobbyServerPackage(String name) {
        Package.LobbyPlayerServerPackage lpsp = new Package.LobbyPlayerServerPackage();
        lpsp.playerID = this.nextID;
        lpsp.name = name;
        lpsp.color = this.takeColor();
        lpsp.ready = false;
        lpsp.team = 0;
        return lpsp;
    }

    private int takeColor() {
        return this.freeColors.removeFirst().getRGB();
    }

    private int changeColor(int currentColor) {
        this.freeColors.addLast(new Color(currentColor));
        return this.takeColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processClientPackage(Object object) {
        if (object instanceof Package.ClientPackage) {
            Object object2 = this.lock;
            synchronized (object2) {
                Package.ClientPackage cp = (Package.ClientPackage)object;
                int playerID = cp.playerID;
                this.playerOrders.set(playerID, cp.orders);
                ++this.finishedPlayers;
                if (cp.simulationNumber != this.simulationNum * 10 + 1) {
                    System.out.println("cp.simulationNumber: " + cp.simulationNumber + " simulationNum*B23Client.localSimulations " + this.simulationNum * 10);
                }
            }
        } else if (object instanceof Package.ClientLobbyPackage) {
            int i;
            Package.ClientLobbyPackage clp = (Package.ClientLobbyPackage)object;
            if (clp.map != -1) {
                this.map = clp.map;
            }
            if (clp.chatMessages != null) {
                i = 0;
                while (i < clp.chatMessages.length) {
                    this.unsentMessages.add(clp.chatMessages[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < this.lobbyPlayers.size()) {
                if (clp.playerID == this.lobbyPlayers.get((int)i).playerID) {
                    Package.LobbyPlayerServerPackage lpsp = this.lobbyPlayers.get(i);
                    int n = lpsp.color = clp.changeColor ? this.changeColor(lpsp.color) : lpsp.color;
                    lpsp.ready = clp.changeReady ? !lpsp.ready : lpsp.ready;
                    lpsp.team = clp.changeTeam ? this.nextTeam(lpsp.team) : lpsp.team;
                    lpsp.name = clp.newName == null ? lpsp.name : clp.newName;
                }
                ++i;
            }
            if (clp.start) {
                this.startGame();
            }
        }
    }

    private int nextTeam(int currentTeam) {
        return (currentTeam + 1) % this.MAX_TEAMS;
    }

    public void initFrame() {
        JFrame frame = new JFrame("Game Server");
        frame.setDefaultCloseOperation(3);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                B23Server.this.server.stop();
            }
        });
        frame.setSize(600, 600);
        frame.add(this);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        this.input = new Input(frame, true);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 1000, 1000);
        if (!this.gameStarted) {
            g.setColor(Color.white);
            int i = 0;
            while (i < this.lobbyPlayers.size()) {
                Package.LobbyPlayerServerPackage lp = this.lobbyPlayers.get(i);
                g.setColor(new Color(lp.color));
                g.drawString("Name: " + lp.name + " ID: " + lp.playerID + " team: " + lp.team + " " + " ready: " + lp.ready + " color: " + lp.color, 20, 20 + 20 * i);
                ++i;
            }
        } else {
            g.setColor(Color.white);
            g.drawString("Players: " + this.players, 20, 20);
            g.drawString("Finished players: " + this.finishedPlayers, 20, 40);
            g.drawString("Simulation num: " + this.simulationNum, 20, 60);
            g.drawString("Simulation running: " + this.simulationRunning, 20, 80);
        }
    }

    public void stopAndClose() {
        this.server.stop();
        this.server.close();
    }
}

