/*
 * Decompiled with CFR 0.152.
 */
package entities.projectiles;

import entities.projectiles.Projectile;
import game.Game;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import sound.Sound;
import utils.Vec2;

public class Laser
extends Projectile {
    Color color;
    double drawLen;
    double angle;

    public Laser(int myPlayerID, int myUnitID, Vec2 startPos, Vec2 targetPos, Game game, LaserType type) {
        super(myPlayerID, myUnitID, startPos, game);
        switch (type) {
            case BLUE: {
                this.color = Color.cyan;
                this.damage = 50.0;
                this.speed = 10.0;
                this.drawLen = 50.0;
                break;
            }
            case GREEN: {
                this.color = Color.yellow;
                this.damage = 30.0;
                this.speed = 10.0;
                this.drawLen = 30.0;
                break;
            }
            case ORANGE: {
                this.color = Color.ORANGE;
                this.damage = 10.0;
                this.speed = 10.0;
                this.drawLen = 20.0;
                break;
            }
            case RED: {
                this.color = Color.RED;
                this.damage = 20.0;
                this.speed = 10.0;
                this.drawLen = 30.0;
                break;
            }
            default: {
                System.err.println("unknown type in laser: " + (Object)((Object)type));
            }
        }
        this.angle = Game.angleFromTo(startPos, targetPos);
        double dx = Math.cos(this.angle) * this.speed;
        double dy = Math.sin(this.angle) * this.speed;
        this.speeds = new Vec2(dx, dy);
        game.sound.playSound(Sound.LASER_ORANGE);
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(3.0f));
        g.setColor(this.color);
        g.drawLine((int)this.pos.x, (int)this.pos.y, (int)(this.pos.x + this.drawLen * Math.cos(this.angle)), (int)(this.pos.y + this.drawLen * Math.sin(this.angle)));
        g2.setStroke(new BasicStroke(1.0f));
    }

    public static enum LaserType {
        ORANGE,
        RED,
        GREEN,
        BLUE;

    }
}

