/*
 * Decompiled with CFR 0.152.
 */
package effects;

import effects.BuildMenuEffect;
import effects.BuildRect;
import effects.BuildSpray;
import effects.Effect;
import effects.Explosion;
import effects.NotEnoughResourcesEffect;
import effects.Smoke;
import entities.units.Unit;
import java.awt.Graphics;
import java.awt.Point;
import java.util.LinkedList;
import sound.Sound;
import utils.Vec2;

public class EffectHandler {
    LinkedList<Effect> effects = new LinkedList();
    Sound sound;

    public EffectHandler(Sound sound) {
        this.sound = sound;
    }

    public void simulate() {
        int i = 0;
        while (i < this.effects.size()) {
            this.effects.get(i).simulate();
            ++i;
        }
        i = 0;
        while (i < this.effects.size()) {
            if (this.effects.get(i).isFinsihed()) {
                this.effects.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void drawGame(Graphics g) {
        int i = 0;
        while (i < this.effects.size()) {
            if (!this.effects.get(i).isOnHud()) {
                this.effects.get(i).draw(g);
            }
            ++i;
        }
    }

    public void drawHud(Graphics g) {
        int i = 0;
        while (i < this.effects.size()) {
            if (this.effects.get(i).isOnHud()) {
                this.effects.get(i).draw(g);
            }
            ++i;
        }
    }

    public void newSmallExplosion(Vec2 pos) {
        this.effects.add(new Explosion(pos, 200, 0.0, 1.0, 150));
        this.sound.playSound(Sound.EXPLOSION_SMALL);
    }

    public void newMediumExplosion(Vec2 pos) {
        this.effects.add(new Explosion(pos, 200, 0.0, 1.0, 150));
        this.effects.add(new Explosion(pos, 50, 1.0, 2.0, 150));
        this.sound.playSound(Sound.EXPLOSION_MEDIUM);
    }

    public void newLargeExplosion(Vec2 pos) {
        this.effects.add(new Explosion(pos, 400, 0.0, 1.0, 150));
        this.effects.add(new Explosion(pos, 100, 2.0, 3.0, 150));
        this.sound.playSound(Sound.EXPLOSION_LARGE);
    }

    public void newMissileSmoke(Vec2 pos) {
        this.effects.add(new Smoke(pos, 100, 0.0, 0.25, 75));
    }

    public void newBuildSpray(Unit builder, Unit buildTarget) {
        this.effects.add(new BuildSpray(builder, buildTarget));
    }

    public void newBuildRect(Point pos, int size) {
        this.effects.add(new BuildRect(pos, size));
        this.sound.playSound(Sound.CLICK);
    }

    public void newBuildMenuEffect(int x, int y, int size) {
        this.sound.playSound(Sound.CLICK);
        this.effects.add(new BuildMenuEffect(x, y, size));
    }

    public void newNotEnoughResourcesEffect(int x, int y) {
        this.effects.add(new NotEnoughResourcesEffect(x, y));
    }
}

