/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.scene.Scene;

public class ZoomScene
extends Scene {
    Texture zoomTex_1;
    Texture zoomTex_2;
    Texture zoomTex_3;

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        Pixmap zoomImage = new Pixmap(Gdx.files.internal("gfx/joystick.png"));
        this.zoomTex_1 = new Texture(zoomImage);
        zoomImage.dispose();
        this.disposables.add(this.zoomTex_1);
        zoomImage = new Pixmap(Gdx.files.internal("gfx/feynman.png"));
        this.zoomTex_2 = new Texture(zoomImage);
        zoomImage.dispose();
        this.disposables.add(this.zoomTex_2);
        zoomImage = new Pixmap(Gdx.files.internal("gfx/duckvase.png"));
        this.zoomTex_3 = new Texture(zoomImage);
        zoomImage.dispose();
        this.disposables.add(this.zoomTex_3);
        this.anim = new AnimationSequence();
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 12000.0f, 14000.0f, -20.0f, 4.0f, 1.0f));
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 10000.0f, 13000.0f, -20.0f, 4.0f, 1.0f));
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 8000.0f, 11000.0f, -20.0f, 4.0f, 1.0f));
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 6000.0f, 9000.0f, -20.0f, 4.0f, 1.0f));
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 4000.0f, 7000.0f, -20.0f, 4.0f, 1.0f));
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 1000.0f, 5000.0f, -20.0f, 4.0f, 1.0f));
        this.anim.addEvent(new ZoomEvent(this.zoomTex_1, 0.0f, 2000.0f, -20.0f, 4.0f, 1.0f));
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.update(deltaTimeMSec);
        Gdx.gl.glClear(16384);
        this.time += deltaTimeMSec;
        this.batch.begin();
        this.anim.draw();
        this.batch.end();
    }

    class ZoomEvent
    extends AnimationEvent {
        float time;
        float wave;
        float panX;
        float panY;
        float endPanX;
        float endPanY;
        Texture texture;
        float startScale;
        float zoomFactor;

        public ZoomEvent(Texture texture, float startTime, float endTime, float endPanX, float endPanY, float startScale) {
            super(startTime, endTime);
            this.zoomFactor = 1.0f;
            this.panX = 0.0f;
            this.panY = 0.0f;
            this.endPanX = endPanX;
            this.endPanY = endPanY;
            this.startScale = startScale;
            this.texture = texture;
        }

        @Override
        public void update(float deltaTimeMSec) {
            this.time += deltaTimeMSec;
            this.wave = this.time / this.runningTime;
            this.panX = this.endPanX;
            this.panY = this.endPanY;
        }

        @Override
        public void draw() {
            int width = ZoomScene.this.zoomTex_1.getWidth();
            int height = ZoomScene.this.zoomTex_1.getHeight();
            int widthHalf = width / 2;
            int heightHalf = height / 2;
            int xPos = ZoomScene.this.SCREEN_W_HALF - ZoomScene.this.zoomTex_1.getWidth() / 2;
            int yPos = ZoomScene.this.SCREEN_H_HALF - ZoomScene.this.zoomTex_1.getHeight() / 2;
            float maxZoom = 1280.0f;
            float timeScale = 1.0E-4f;
            float zoomFactor = 1.0f + maxZoom * this.wave;
            float rot = 0.0f;
            float scaleX = zoomFactor;
            float scaleY = zoomFactor;
            ZoomScene.this.batch.draw(this.texture, xPos, yPos, (float)widthHalf + this.panX + 0.5f, (float)heightHalf - this.panY + 0.5f, width, height, this.startScale + scaleX, this.startScale + scaleY, rot, 0, 0, width, height, false, false);
        }
    }
}

