/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.nio.ByteBuffer;
import java.util.Random;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.scene.Scene;
import org.taongad.utils.FastMath;

public class NoiseScene
extends Scene {
    Pixmap noisePixmap;
    Texture noiseTex;
    Pixmap circlePixmap;
    Texture circleTexture;
    Pixmap circleShadowPixmap;
    Texture circleShadowTexture;
    BitmapFont font;
    Random rng;
    final int NOISE_SCALE = 3;
    final int CIRCLE_WIDTH = 32;
    float time;

    @Override
    public void load() {
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/LCD-U___.TTF"));
        this.font = generator.generateFont(160);
        generator.dispose();
        this.rng = new Random();
        this.noisePixmap = new Pixmap(384, 384, Pixmap.Format.RGB888);
        this.generateNoisePixmap();
        this.noiseTex = new Texture(this.noisePixmap);
        this.disposables.add(this.noiseTex);
        this.batch = new SpriteBatch();
        this.disposables.add(this.batch);
        int adoreYPos = 570;
        int xPos = 660;
        int yPos = 360;
        this.anim = new AnimationSequence();
        this.anim.addEvent(new GreetEvent("We adore", 500.0f, 3000.0f, xPos, adoreYPos));
        this.anim.addEvent(new GreetEvent("SceneSat", 3000.0f, 4500.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Fairlight", 4500.0f, 6000.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Consipracy", 6000.0f, 7500.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("ASD", 7500.0f, 9000.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("TBL", 9000.0f, 10500.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("MFX", 10500.0f, 12000.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Kewlers", 12000.0f, 13500.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Farbrauch", 13500.0f, 15000.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Candela", 15000.0f, 16500.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Edis", 16500.0f, 18000.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Peter_W", 18000.0f, 19200.0f, xPos, yPos));
        this.anim.addEvent(new GreetEvent("Malmen", 19200.0f, 20400.0f, xPos, yPos));
    }

    private void renderShadowCircle(float alpha) {
        this.circleShadowPixmap.setColor(0);
        this.circleShadowPixmap.fill();
        int alphaChan = (int)(255.0f * alpha) & 0xFF;
        alphaChan = alphaChan < 0 ? 0 : alphaChan;
        this.circleShadowPixmap.setColor(0 + alphaChan);
        this.circleShadowPixmap.fillCircle(15, 15, 15);
        this.circleShadowTexture.draw(this.circleShadowPixmap, 0, 0);
    }

    private void renderCircle(float alpha) {
        this.circlePixmap.setColor(0);
        this.circlePixmap.fill();
        int alphaChan = (int)(255.0f * alpha) & 0xFF;
        alphaChan = alphaChan < 0 ? 0 : alphaChan;
        this.circlePixmap.setColor(-1);
        this.circlePixmap.fillCircle(15, 15, 15);
        int x = 0;
        while (x < this.circlePixmap.getWidth()) {
            int y = 0;
            while (y < this.circlePixmap.getHeight()) {
                int pixel = this.circlePixmap.getPixel(x, y);
                if (pixel < 0) {
                    int color = -1;
                    if (this.rng.nextBoolean()) {
                        color = 255;
                    }
                    this.circlePixmap.drawPixel(x, y, color);
                }
                ++y;
            }
            ++x;
        }
        this.circlePixmap.setColor(255);
        this.circlePixmap.drawCircle(15, 15, 15);
        this.circleTexture.draw(this.circlePixmap, 0, 0);
    }

    private void generateNoisePixmap() {
        int w = this.noisePixmap.getWidth();
        int h = this.noisePixmap.getHeight();
        ByteBuffer buffer = this.noisePixmap.getPixels();
        buffer.clear();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                boolean drawWhite = this.rng.nextBoolean();
                int color = drawWhite ? -1 : 255;
                buffer.put((byte)(color >> 24 & 0xFF));
                buffer.put((byte)(color >> 16 & 0xFF));
                buffer.put((byte)(color >> 8 & 0xFF));
                ++y;
            }
            ++x;
        }
        buffer.flip();
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec / 100.0f;
        this.renderNoise();
        this.update(deltaTimeMSec);
        this.batch.begin();
        this.batch.disableBlending();
        this.batch.draw(this.noiseTex, 0.0f, 0.0f, 0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), 1.0f, 1.0f, 0.0f, 0, 0, 384, 216, false, false);
        this.batch.enableBlending();
        this.anim.draw();
        this.batch.end();
    }

    public void renderNoise() {
        this.generateNoisePixmap();
        this.noiseTex.draw(this.noisePixmap, 0, 0);
    }

    class GreetEvent
    extends AnimationEvent {
        int xPos;
        int yPos;
        int offset;
        float duration;
        float rampTime;
        float holdTime;
        String text;
        BitmapFont.TextBounds bounds;

        GreetEvent(String text, float startTime, float stopTime, int x, int y) {
            super(startTime, stopTime);
            this.xPos = 0;
            this.yPos = 0;
            this.duration = 0.0f;
            this.xPos = x;
            this.yPos = y;
            this.text = text;
            this.bounds = NoiseScene.this.font.getBounds(text);
            this.xPos = (int)((float)this.xPos - this.bounds.width / 2.0f);
            this.yPos = (int)((float)this.yPos + this.bounds.height / 2.0f);
            this.rampTime = this.runningTime * 0.1f;
            this.holdTime = this.runningTime - this.rampTime * 2.0f;
        }

        @Override
        public void update(float deltaTimeMSec) {
            this.duration += deltaTimeMSec;
            if (this.duration <= this.rampTime) {
                float timePos = this.duration / this.rampTime;
                float wave = FastMath.sin(timePos * 1.5707964f);
                this.offset = (int)(50.0f * wave);
            } else if (this.duration >= this.rampTime + this.holdTime) {
                float timePos = 1.0f - (this.duration - (this.rampTime + this.holdTime)) / this.rampTime;
                float wave = FastMath.sin(timePos * 1.5707964f);
                this.offset = (int)(50.0f * wave);
            } else {
                this.offset = 50;
            }
        }

        @Override
        public void draw() {
            NoiseScene.this.font.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            NoiseScene.this.font.draw(NoiseScene.this.batch, this.text, this.xPos, this.yPos);
            NoiseScene.this.font.setColor(1.0f, 0.0f, 0.0f, 1.0f);
            NoiseScene.this.font.draw(NoiseScene.this.batch, this.text, this.xPos - this.offset, this.yPos + this.offset);
        }
    }
}

