/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.demo;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.FPSLogger;
import java.util.logging.Logger;
import org.taongad.scene.SceneManager;

public class DemoApplication
implements ApplicationListener {
    Logger log = Logger.getLogger(DemoApplication.class.getName());
    FPSLogger fpsLogger = new FPSLogger();
    public static final float FRAMETIME = 16.666666f;
    private static float deltaTimeMSec;
    static final float INPUT_COOLDOWN = 166.66666f;
    private float timeSinceLastInput = 0.0f;
    SceneManager sceneManager;

    @Override
    public void create() {
        Thread.currentThread().setPriority(10);
        Gdx.input.setCursorCatched(true);
        this.log.info("Creating ApplicationListener...");
        this.sceneManager = new SceneManager();
        this.sceneManager.load();
    }

    @Override
    public void resize(int width, int height) {
        this.log.info("Resizing - w: " + width + ", h: " + height);
    }

    @Override
    public void render() {
        this.handleInput();
        this.sceneManager.draw(deltaTimeMSec += Gdx.graphics.getDeltaTime() * 1000.0f);
        deltaTimeMSec = 0.0f;
    }

    private void handleInput() {
        if (Gdx.input.isKeyPressed(131)) {
            Gdx.app.exit();
        }
        this.timeSinceLastInput += Gdx.graphics.getDeltaTime() * 1000.0f;
    }

    @Override
    public void pause() {
        this.log.info("Paused...");
    }

    @Override
    public void resume() {
        this.log.info("Resumed...");
    }

    @Override
    public void dispose() {
        this.log.info("Disposing ApplicationListener...");
        this.sceneManager.dispose();
    }
}

