/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.anim;

import java.util.ArrayList;
import java.util.List;
import org.taongad.anim.AnimationEvent;

public class AnimationSequence {
    float totalRunningTime = 0.0f;
    List<AnimationEvent> plannedEvents = new ArrayList<AnimationEvent>();
    List<AnimationEvent> ongoingEvents = new ArrayList<AnimationEvent>();

    public void addEvent(AnimationEvent event) {
        this.plannedEvents.add(event);
    }

    public void update(float deltaTimeMSec) {
        this.totalRunningTime += deltaTimeMSec;
        int i = 0;
        while (i < this.plannedEvents.size()) {
            AnimationEvent plannedEvent = this.plannedEvents.get(i);
            if (plannedEvent.isStarting(this.totalRunningTime)) {
                this.ongoingEvents.add(this.plannedEvents.remove(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.ongoingEvents.size()) {
            AnimationEvent ongoingEvent = this.ongoingEvents.get(i);
            if (ongoingEvent.isDone(this.totalRunningTime)) {
                if (ongoingEvent.runningTime < ongoingEvent.endTime) {
                    ongoingEvent.update(ongoingEvent.endTime - ongoingEvent.runningTime);
                }
                ongoingEvent = this.ongoingEvents.remove(i);
                ongoingEvent.dispose();
            } else {
                ongoingEvent.update(deltaTimeMSec);
            }
            ++i;
        }
    }

    public void draw() {
        for (AnimationEvent ongoingEvent : this.ongoingEvents) {
            ongoingEvent.draw();
        }
    }
}

