

      uniform sampler2D rubyTexture;
      uniform vec2      rubyInputSize;
      uniform vec2      rubyTextureSize;
      uniform vec2      rubyOutputSize;

      #define TEX2D(v) texture2D(rubyTexture, (v))

      void main()
      {
        mat3x3 rgb2yuv = mat3x3(0.299,-0.14713, 0.615,
                 0.587,-0.28886,-0.51499,
                 0.114, 0.436  ,-0.10001);
        mat3x3 yuv2rgb = mat3x3(1.0, 1.0, 1.0,
                 0.0,-0.39465,2.03211,
                 1.13983,-0.58060,0.0);


        vec4 sum   = vec4(0.0);

        float wid = 3.0;
        vec4 c1 = vec4(exp(-1.0/wid/wid));
        vec4 c2 = vec4(exp(-4.0/wid/wid));
        vec4 c3 = vec4(exp(-9.0/wid/wid));
        vec4 c4 = vec4(exp(-16.0/wid/wid));
        vec4 norm = 1.0 / (vec4(1.0) + vec4(2.0)*(c1+c2+c3+c4));

        vec2 xy = gl_TexCoord[0].st;
        float onex = 1.0 / rubyTextureSize.x * 4.0;

        sum += TEX2D(xy + vec2(-4.0 * onex,  0.0)) * c4;
        sum += TEX2D(xy + vec2(-3.0 * onex,  0.0)) * c3;
        sum += TEX2D(xy + vec2(-2.0 * onex,  0.0)) * c2;
        sum += TEX2D(xy + vec2(-1.0 * onex,  0.0)) * c1;
        sum += TEX2D(xy);
        sum += TEX2D(xy + vec2(+1.0 * onex,  0.0)) * c1;
        sum += TEX2D(xy + vec2(+2.0 * onex,  0.0)) * c2;
        sum += TEX2D(xy + vec2(+3.0 * onex,  0.0)) * c3;
        sum += TEX2D(xy + vec2(+4.0 * onex,  0.0)) * c4;

        float y = (rgb2yuv * TEX2D(xy).rgb).x;
        vec2 uv = (rgb2yuv * (sum.rgb*norm.rgb)).yz;

        gl_FragColor = vec4(yuv2rgb * vec3(y, uv), 1.0);
        //gl_FragColor.rgb = TEX2D(xy);
      }
