#version 330
 
layout(lines) in;
layout(triangle_strip, max_vertices = 4) out;

in float ParticleSize[];
in float ParticleBrightness[];
out vec2 TexCoord;
out float fParticleBrightness;

void main() 
{
  gl_Position = ( gl_in[0].gl_Position + vec4( -0.5 * ParticleSize[0], -0.5 * ParticleSize[0], 0.0, 0.0 ) );
  TexCoord = vec2( 0.0, 0.0 );
  fParticleBrightness = ParticleBrightness[0];
  EmitVertex();
  gl_Position = ( gl_in[0].gl_Position + vec4( 0.5 * ParticleSize[0], -0.5 * ParticleSize[0], 0.0, 0.0 ) );
  TexCoord = vec2( 1.0, 0.0 );
  fParticleBrightness = ParticleBrightness[0];
  EmitVertex();
  gl_Position = ( gl_in[0].gl_Position + vec4( -0.5 * ParticleSize[0], 0.5 * ParticleSize[0], 0.0, 0.0 ) );
  TexCoord = vec2( 0.0, 1.0 );
  fParticleBrightness = ParticleBrightness[0];
  EmitVertex();
  gl_Position = ( gl_in[0].gl_Position + vec4( 0.5 * ParticleSize[0], 0.5 * ParticleSize[0], 0.0, 0.0 ) );
  TexCoord = vec2( 1.0, 1.0 );
  fParticleBrightness = ParticleBrightness[0];
  EmitVertex();
  EndPrimitive();
}