#version 330

in vec2 vTexCoord;
in vec4 vSunPos;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uTexSampler;
uniform sampler2D uDepthSampler;

uniform float uNumSamples;
uniform float uDensity;
uniform float uDecay;
uniform float uWeight;
uniform float uExposure;

void main()
{
	vec2 sunPos = ( vSunPos / vSunPos.w ).xy;
	sunPos = ( sunPos + 1.0 ) / 2.0;
	
	vec2 lightDelta = vTexCoord - sunPos;
	lightDelta *= ( 1.0 / uNumSamples ) * uDensity;
	
	vec3 sceneColor = texture( uTexSampler, vTexCoord ).rgb;
	float illuminationDecay = 1.0;
	vec2 currentTexCoord = vTexCoord;
	for( int i = 0; i < uNumSamples; i++ )
	{
		currentTexCoord -= lightDelta;
		vec3 sample = texture( uTexSampler, currentTexCoord ).rgb;
		sample *= illuminationDecay * uWeight;
		sceneColor += sample;
		illuminationDecay *= uDecay;
	}
	outColor = vec4( sceneColor * uExposure, 1.0 );
}