#version 330

in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uTexSampler;
uniform sampler2D uBlurredSampler;

void main()
{
	vec4 shrunkColor = texture( uTexSampler, vTexCoord );
	vec4 blurredColor = texture( uBlurredSampler, vTexCoord );
	vec3 color = shrunkColor.rgb;
	float coc = 2.0 * max( blurredColor.a, shrunkColor.a ) - shrunkColor.a;
	outColor = vec4( color, coc );
}