//Namespace
this.wideload = this.wideload || {};

/**
* Part 2 
*/

(function(){

	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	*/
	var Part3 = function(beginTime, prepareTime, main){
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
		this.curPos = 0;
		this.positions = 
		[
			{
				time: 5000,
				init: {x:270,y:0,z:-0},
				target: new THREE.Vector3(1000,0,0),
				delta: {x:-700, y:200, z:0},
				colors: {rm: 0.4, gm:1.0, bm:0.7},
				balls: new THREE.Vector3(80,80,80),
				rot: 40
				
			},
			{
				time: 6000,
				init: {x:300,y:0,z:250},
				target: new THREE.Vector3(-1000,800,0),
				delta: {x:-150, y:-100, z:-300},
				colors: {rm: 0.2, gm:1.0, bm:0.9},
				balls: new THREE.Vector3(80,80,140),
				rot: 40
			},
			{
				time: 6000,
				init: {x:-200,y:300,z:0},
				target: new THREE.Vector3(00,0,700),
				delta: {x:500, y:-400, z:0},
				colors: {rm: 0.0, gm:0.6, bm:1.0},
				balls: new THREE.Vector3(0,80,80),
				rot: 40
			},
			{
				time: 6000,
				init: {x:0,y:0,z:0},
				target: new THREE.Vector3(0,-700,0),
				delta: {x:+400, y:0, z:0},
				colors: {rm: 0.6, gm:0.3, bm:0.5},
				balls: new THREE.Vector3(80,80,80),
				rot: 40
			},
			{
				time: 6000,
				init: {x:-150,y:0,z:0},
				target: new THREE.Vector3(0,0,600),
				delta: {x:400, y:-300, z:200},
				colors: {rm: 0.4, gm:1.0, bm:0.4},
				balls: new THREE.Vector3(180,80,80),
				rot: 40
			},
			{
				time: 5000,
				init: {x:0,y:0,z:150},
				target: new THREE.Vector3(0,0,1000),
				delta: {x:-0, y:0, z:-200},
				colors: {rm: 1.0, gm:0.2, bm:0.2},
				balls: new THREE.Vector3(80,80,80),
				rot: 60
			}, 
			{
				time: 3800,
				init: {x:-500,y:0,z:0},
				target: new THREE.Vector3(0,0,0),
				delta: {x:-2800, y:0, z:0},
				colors: {rm: 0.9, gm:1.0, bm:0.9},
				balls: new THREE.Vector3(10080,80,80),
				rot: 50
			}
			
		]
		
		var sum = 0;
		for(var i = 0; i < this.positions.length; i++)
		{
			sum += this.positions[i].time;
			this.positions[i].otime = this.positions[i].time;
			this.positions[i].otime += sum-this.positions[i].time;
		}
	}
	
	//Expose class
	wideload.Part3 = Part3;
	
	var p = Part3.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize_Super = p.initialize;
	p.initialize = function(){
		this.initialize_Super();
		this.scene.remove(this.camera);
		this.camera = new THREE.PerspectiveCamera( 45, this.width / this.height);
		this.camera.position.z = 0;
		this.scene.add(this.camera);
		var ambient = new THREE.AmbientLight(0x202020);
		this.scene.add(ambient);
		this.light = new THREE.PointLight(0xFFFFFF,1,300);
		this.light.position.set(-100,0,0);
		this.scene.add(this.light);
		
		this.tentacles = new wideload.Tentacles();
		this.tentacles.init();
		this.scene.add(this.tentacles.group);
		
		//this can't be used if there is no lights!
		/*var material = new THREE.MeshLambertMaterial({
				map : previous,
		  color : 0xFFFFFF,
		  eimissive : 0x000033,
		  ambient : 0x000033
			});*/
		/*
		var material = new THREE.MeshBasicMaterial({
				color:0xFFFFFF,
				wireframe: false,
				side: THREE.BackSide
			});
			*/
		this.uniforms = {
			delta: {type: 'f', value:0.0},
			rm: {type: 'f', value:this.positions[0].colors.rm},
			gm: {type: 'f', value:this.positions[0].colors.gm},			
			bm: {type: 'f', value:this.positions[0].colors.bm},
			size: {type: 'f', value:0}
			
		};
		this.material = new THREE.ShaderMaterial({
		//	color:0x606060,
			wireframe: false,
			side: THREE.DoubleSide,
			shading: 1,
			attributes: {},
			uniforms: this.uniforms,
			vertexShader: wideload.BallVertexShader.vertexShader,
			fragmentShader: wideload.BallVertexShader.fragmentShader
		});
		/*
		this.ball = new THREE.Mesh(new THREE.SphereGeometry(wideload.Main.RESOLUTION[0]/10, 32, 32), material);
			this.ball.position.z = -wideload.Main.RESOLUTION[0]/10;
			this.scene.add(this.ball);
		*/
		
		var geometry = new THREE.IcosahedronGeometry(480,3);
		
		this.ball = new THREE.Mesh(geometry, this.material);
		this.ball.position.z = 0;
		this.scene.add(this.ball);
		
		this.dotScreenEffect = new THREE.ShaderPass(THREE.RGBShiftShader);
		this.dotScreenEffect.uniforms['amount'].value = 0.0;
		
		this.composer = new THREE.EffectComposer(this.main.renderer,this.renderTarget);
		this.composer.addPass(new THREE.RenderPass(this.scene, this.camera));
		this.composer.addPass(this.dotScreenEffect);
		
		for(var i = 0; i < this.positions.length; i++)
		{
			$("#g"+(i)+"_1").fadeOut(0);
			$("#g"+(i)+"_2").fadeOut(0);
			$("#g"+(i)+"_3").fadeOut(0);
			$("#g"+(i)+"_4").fadeOut(0);
			$("#g"+(i)+"_5").fadeOut(0);
		}
		var fontSize = Math.floor(52 * this.width/1280);
		var lineSize = Math.floor(60 * this.width/1280);
		$("#greets").css("font-size", (fontSize+"px"));
		$("#greets").css("line-height", (lineSize+"px"));
	}
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
		document.getElementById("greets").style.display = "block";
		
		this.main.renderer.setClearColor(0x000000);
	}
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
		this.startTime = elapsedtime;
		this.realStart = elapsedtime;
		this.faded = false;
		this.extraDelta = 0;
		this.main.effectBloom.materialCopy.uniforms.opacity.value = 0.1;
	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime, td){
		this.uniforms.delta.value+=0.05*td;
		if(this.curPos == this.positions.length-1)
		{
			this.extraDelta+=0.0002*td;
		}
		//this.camera.rotation.y += Math.PI/1000;
		//this.camera.rotation.x += Math.PI/1700;
		//this.camera.rotation.z += Math.PI/4600;
		
		var to = this.positions[this.curPos];
		if(to)
		{
			this.uniforms.size.value = to.rot;
			this.tentacles.update( to.colors.rm, to.colors.gm, to.colors.bm, this.curPos == this.positions.length-2 && elapsedtime-this.startTime > to.time-4000 ,td);
		}
		else
		{
			this.tentacles.update( 0,0,0, true,td );
		}
		
		var offset = 300;
		var outDelay = 0;
		var inDelay = 500;
		var fade = 700;
		
		if( to != null &&  elapsedtime-this.startTime > to.time -2000 && !this.faded)
		{
			this.faded = true;
			$("#g"+(this.curPos)+"_1").delay(outDelay).fadeOut(fade);
			$("#g"+(this.curPos)+"_2").delay(outDelay+offset).fadeOut(fade);
			$("#g"+(this.curPos)+"_3").delay(outDelay+offset*2).fadeOut(fade);
			$("#g"+(this.curPos)+"_4").delay(outDelay+offset*3).fadeOut(fade);
			$("#g"+(this.curPos)+"_5").delay(outDelay+offset*4).fadeOut(fade);
		}
		
		while(to != null && elapsedtime-this.startTime > to.time)
		{
			console.log("Swap at " + (elapsedtime-this.startTime));
			this.curPos++
			
			if(this.curPos>0)
			{
				
				this.faded = false;
				
				$("#g"+(this.curPos)+"_1").delay(inDelay).fadeIn(fade);
				$("#g"+(this.curPos)+"_2").delay(inDelay+offset).fadeIn(fade);
				$("#g"+(this.curPos)+"_3").delay(inDelay+offset*2).fadeIn(fade);
				$("#g"+(this.curPos)+"_4").delay(inDelay+offset*3).fadeIn(fade);
				$("#g"+(this.curPos)+"_5").delay(inDelay+offset*4).fadeIn(fade);
				
				
			}
		
			if(this.curPos >= this.positions.length)
			{
				to = null;
				break;
			}
			to = this.positions[this.curPos];
			this.startTime = this.realStart+this.positions[this.curPos-1].otime;
			
			this.uniforms.rm.value = to.colors.rm;
			this.uniforms.gm.value = to.colors.gm;
			this.uniforms.bm.value = to.colors.bm;
			this.tentacles.clearColors();
		}
		if(to != null)
		{
			this.camera.position.x = to.init.x + (elapsedtime-this.startTime)/to.time * to.delta.x;
			this.camera.position.y = to.init.y + (elapsedtime-this.startTime)/to.time * to.delta.y;
			this.camera.position.z = to.init.z + (elapsedtime-this.startTime)/to.time * to.delta.z;
			
			var normal = to.target.clone();
			normal.sub(this.camera.position);
			normal.normalize();
			this.tentacles.group.position.x = this.camera.position.x+normal.x*to.balls.x;
			this.tentacles.group.position.y = this.camera.position.y+normal.y*to.balls.y;
			this.tentacles.group.position.z = this.camera.position.z + normal.z*to.balls.z;
			
			this.light.position.x = this.camera.position.x+normal.x*(to.balls.x+100);
			this.light.position.y = this.camera.position.y+normal.y*(to.balls.y+100);
			this.light.position.z = this.camera.position.z+normal.z*(to.balls.z+100);
			
			this.camera.lookAt(to.target);
		}
		this.dotScreenEffect.uniforms['amount'].value = wideload.Random.nextFloat()*(0.009+this.extraDelta)+0.005;

	}
	
	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
		//wideload.Main.RENDERER.render(this.scene, this.main.MAIN_CAMERA_PERSPECTIVE, renderTarget);
		this.composer.render();
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	
	}
	
}())