/**

 */

wideload.BallVertexShader = {

	uniforms: {

		"amount":   { type: "f", value: 0.005 },
		"size":   { type: "f", value: 40 },

	},

	vertexShader: [

		"varying vec3 vNormal;",
		"uniform float delta;",
		"uniform float size;",

		"void main() {",

			"vNormal = normal;",
			"vec3 p = position;",
			"p.z += sin(delta+p.x)*size;",
			
			"p.x +=0.0;// sin(1.0 * p.x+delta)*20.0;",
			"p.y +=0.0;// cos(1.0 * p.y+delta)*2.0;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [

		"varying vec3 vNormal;",
		"uniform float rm;",
		"uniform float gm;",
		"uniform float bm;",
		
		"void main() {",
			"vec3 light = vec3(0.4,0.1,0.2);",
			"light = normalize(light);",
			"float dProd = abs(dot(vNormal, light));",
			"gl_FragColor = vec4(abs(dProd)*rm, abs(dProd)*gm, abs(dProd)*bm, 1.0);",

		"}"

	].join("\n")

};
