wideload.underwaterShader = {

    uniforms: {
        "tDiffuse" :  { type: "t", value: null },
        "time":   { type: "f", value: 1.0 },

    },

    vertexShader: [

        "varying vec2 vUv;",

        "void main() {",

            "vUv = uv;",
            "gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

        "}"

    ].join("\n"),

    fragmentShader: [

        "uniform sampler2D tDiffuse;",
        "uniform float time;",
        
        "varying vec2 vUv;",

        "void main() {",

            "vec2 delta = vec2(sin(time + vUv.x*9.0 + vUv.y*vUv.y*4.5)*0.02 , cos(time + vUv.y*13.0 + vUv.x*vUv.x*2.5)*0.02 );",
            "vec2 newUV = vUv + delta;",

            "vec4 end = vec4(0,0,0,0);",
            "for (int i = 0; i < 12; i++)",
            "{",
                "vec2 Coord = newUV + 0.005;",
                "end += texture2D(tDiffuse, Coord)/5.0;",
            "}",
            "end += texture2D(tDiffuse, vUv)/2.0;",
            "end.a = 1.0;",
            "gl_FragColor = end;",
            

        "}"

    ].join("\n")

};