/**

 */

wideload.ParticleShader = {

	uniforms: {

		"delta":   { type: "f", value: 0.005 },

	},

	vertexShader: [

		"varying vec3 vNormal;",
		"uniform float delta;",
		"uniform float collapse;",
		"uniform float distance;",
		"varying vec2 vUv;",

		"void main() {",
			"vUv = uv;",
			"vNormal = normal;",
			"vec3 p = position;",
			
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [

		"varying vec3 vNormal;",
		"uniform float rm;",
		"uniform float gm;",
		"uniform float bm;",
		"uniform float time;",
		"uniform vec2 midPoint;",
		"varying vec2 vUv;",

		"void main() {",
			"vec2 position = (vUv.xy );",
			"float col = 0.0;",
			
			"col = min(0.4,time*(0.4-length(position - vec2(0.5,0.5))))/0.4;", 
			"vec3 color = vec3(col,col,col);",
			"gl_FragColor = vec4(color.r,color.g, color.b, 1.0);",

		"}"

	].join("\n")

};
