(function()
{
	

	var Particle = function()
	{
		this.x0 = 0;
		this.y0 = 0;
		this.x1 = 0;
		this.y1 = 0;
		this.amount = 20;
		this.chainAmount = 30;
	}
	wideload.Particle = Particle;
	
	var p = Particle.prototype;
	p.cleard = function(scene)
	{
		for(var i = 0; i<this.lines.length; i++)
		{
			scene.remove(this.lines[i]);
		}
	}
	p.fadeOut = function(scene)
	{
		this.fading = true;
		this.fadeIndex = 0;
	}
	p.init = function(scene,x,y,z, color)
	{
		this.chains = [];
		this.lines = [];
		this.geometries = [];
		
		this.material = new THREE.LineBasicMaterial({
			color : color,
			linewidth : 1
		});
		for(var i = 0; i < this.chainAmount; i++)
		{
			this.chains.push([]);
			var geometry = new THREE.Geometry();
			this.geometries.push(geometry);
			for(var j = 0; j < this.amount; j++)
			{
				geometry.vertices.push(new THREE.Vector3(x, y, z));
				geometry.dynamic = true;
			}
			var line = new THREE.Line(geometry.clone(), this.material);
			this.lines.push(line);
			//this.chains[i].push(line);
			scene.add(line);
		}
		
		
		this.color = 0;
		this.count = 0;
	}
	
	p.update = function(tx, ty, tz, sizeOff, rndMp)
	{
		//Target coordinates.
		var prevX = tx;
		var prevY = ty;
		var prevZ = tz;
		this.count++;
		if(this.fading)
		{
		this.material.color = new THREE.Color(this.color<<16|this.color<<8|this.color| (255-this.color)<<24);
		this.color+=10;
		if(this.color > 255)
		{
			this.color = 255;
			for(var i = 0; i < this.lines.length; i++)
			{
			var line = this.lines[i];
				line.geometry.vertices = [];
				line.geometry.verticesNeedUpdate = true;
				if(!this.clered)
				{
					this.cleard(this.scene);
					this.clered = true;
				}
			}
		}
		}
		for(var i = 0; i < this.chains.length; i++)
		{
			var chain = this.chains[i];
			prevX = tx;// + Math.sin(i/this.chainAmount*Math.PI)*4;
			prevY = ty;// + Math.sin(i/this.chainAmount*Math.PI)*4;
			prevZ = tz;// + Math.sin(i/this.chainAmount*Math.PI)*4;
			var line = this.lines[i];
			var geometry = this.geometries[i];
			var off = 0;
			for(var j = 0; j < line.geometry.vertices.length ; j++)
			{
				
			//	line.geometry.vertices[1].x = prevX;
			//	line.geometry.vertices[1].y = prevY;
			//	line.geometry.vertices[1].z = prevZ;
				
				//offset first point
				geometry.vertices[j].x -= (geometry.vertices[j].x - prevX)/4;
				geometry.vertices[j].y -= (geometry.vertices[j].y - prevY)/4;
				geometry.vertices[j].z -= (geometry.vertices[j].z - prevZ)/4;
				
				prevX = geometry.vertices[j].x;//+((i-this.chains.lenght/2)*0.01);
				prevY = geometry.vertices[j].y;//+((i-this.chains.lenght/2)*0.01);
				prevZ = geometry.vertices[j].z;//+((i-this.chains.lenght/2)*0.01);
				
				line.geometry.vertices[j].x = geometry.vertices[j].x + Math.sin(j/11+off+i/5+this.count/20)*off+(rndMp*wideload.Random.nextFloat());
				line.geometry.vertices[j].y = geometry.vertices[j].y + Math.sin(j/21+off+i/13+this.count/20)*off+(rndMp*wideload.Random.nextFloat());
				line.geometry.vertices[j].z = geometry.vertices[j].z + Math.sin(j/31+off+i/15+this.count/20)*off+(rndMp*wideload.Random.nextFloat());
				off+=0.55-sizeOff;
				/*
				//offset second point
				line.geometry.vertices[1].x -= (line.geometry.vertices[1].x - prevX)/4;
				line.geometry.vertices[1].y -= (line.geometry.vertices[1].y - prevY)/4;
				line.geometry.vertices[1].z -= (line.geometry.vertices[1].z - prevZ)/4;
				
				prevX = line.geometry.vertices[1].x;
				prevY = line.geometry.vertices[1].y;
				prevZ = line.geometry.vertices[1].z;
				*/
				
			}
			line.geometry.verticesNeedUpdate = true;
		}

	}
	

}())