//Namespace
this.wideload = this.wideload || {};

/**
* Maze 
*/

(function(){
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	*/
	var Maze = function(beginTime, prepareTime, main){
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.main = main;



	}
	//Expose class
	wideload.Maze = Maze;
	
	var p = Maze.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(){
    //main renderer
    this.renderTarget = new THREE.WebGLRenderTarget(this.main.resolution[0], this.main.resolution[1]);
    
    //maze renderer
    this.textureTarget = new THREE.WebGLRenderTarget(this.main.resolution[0], this.main.resolution[1]);
    
    this.maxX = this.main.resolution[0]/2;
    this.minX = -this.main.resolution[0]/2;
    this.maxY = this.main.resolution[1]/2;
    this.minY = -this.main.resolution[1]/2;
    this.camX=0;
	this.camY=0;
	this.camZ=0;
	this.ctx =0;
	this.cty=0;
	this.ctz=0;
    this.material = new THREE.LineBasicMaterial({
      color : (0xFFFFFF)
    });
    
    //MAZESCENE
    this.scene = new THREE.Scene();
    this.cameraO = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
    this.cameraO.position.z = 1;
    this.scene.add(this.cameraO);
    
    //MAIN SCENE
    this.scene2 = new THREE.Scene();
    this.camera2 = new THREE.PerspectiveCamera(30,1280/720,0.1,10000);
    this.camera2.position.z = 10;
    this.camera2.position.y = 56;
    this.camera2.position.x = 1;
    this.camera2.look = new THREE.Vector3(-15,10,10)
    this.camera2.lookAt(this.camera2.look);
    this.scene2.add(this.camera2);
    
    var planeGeometry = new THREE.PlaneGeometry(this.main.resolution[0], this.main.resolution[1]);
    //var planeMaterial = new THREE.MeshBasicMaterial({map : this.textureTarget});
    this.uniforms =  {
          time : {type : "f", value: 0.0},
          phase : {type : "f", value:0.0},
          texture : {type : "t", value: this.textureTarget}
        };
    var planeMaterial = new THREE.ShaderMaterial({
      	uniforms:this.uniforms,
        vertexShader: document.getElementById( 'mazeVertex' ).textContent,
        fragmentShader: document.getElementById( 'mazePixel' ).textContent
    });
    
    var plane = new THREE.Mesh(planeGeometry, planeMaterial);
  //  this.scene2.add(plane);
    
    this.random = wideload.Random;
    this.maze = new THREE.Object3D();
    this.scene.add(this.maze);
    
    this.recursionLimit = 5;
    this.vertical = [];
    this.horizontal = [];
    this.countV = 0;
    this.countH = 0;
    this.linesInDrawing = [];
    this.cubes = [];
    this.explodeOfset = 0.2;
    this.effectTime = 0;

    this.splitTimes =[];

    this.phase = 1;
    this.group1 = new THREE.Object3D();
    this.group2 = new THREE.Object3D();
    this.group3 = new THREE.Object3D();
    for(var i = 0; i < 4; ++i){
      for(var j = 0; j  < 4; ++j){
        for(var k = 0; k < 4; ++k){
          if((i == 1 || i == 2) && (j == 1 || j == 2) && (k == 1 || k == 2)){

          }
          else{
          var position = new THREE.Vector3(i*10+5,j*10+5,k*10+5);
          var cubeG = new THREE.CubeGeometry(10,10,10);
          var cube = new THREE.Mesh(cubeG,planeMaterial);
          cube.position = position;
          this.cubes.push(cube);
          cube.originalPosition = position.clone();
          var inAGroup = false;
          cube.addedTotal = 0;
          this.scene2.add(cube);
          }
          
        } 
      }
    }
    this.scene2.add(this.group1);
//    this.scene2.add(this.group2);
//    this.scene2.add(this.group3);


    this.row = 0;
    this.density = 33;
    
    
    this.divide(this.minX, this.maxX, this.minY, this.maxY, 0);
    //this.grid = this.tossAcoin(this.minX, this.maxX, this.minY, this.maxY, this.density);

    //COMPOSER & Effects
    this.dotScreenEffect = new THREE.ShaderPass(THREE.RGBShiftShader);
    this.dotScreenEffect.uniforms['amount'].value = 0.0;

    this.brightnessEffect = new THREE.ShaderPass(THREE.BrightnessContrastShader);

    this.composer = new THREE.EffectComposer(this.main.renderer,this.renderTarget);
   // this.composer.addPass(new THREE.RenderPass(this.scene, this.camera0));
    this.composer.addPass(new THREE.RenderPass(this.scene2, this.camera2));
    this.composer.addPass(this.brightnessEffect);
    this.composer.addPass(this.dotScreenEffect);
	}

  function buildHelpLines(scene){
  var material = new THREE.LineBasicMaterial({
    color: 0xff0000
  });
  var g = new THREE.Geometry();
  g.vertices.push(new THREE.Vector3(-100,0,0));
  g.vertices.push(new THREE.Vector3(100,0,0));
  var l = new THREE.Line(g, material);
  scene.add(l);

var material = new THREE.LineBasicMaterial({
    color: 0x00ff00
  });
  var g = new THREE.Geometry();
  g.vertices.push(new THREE.Vector3(0,100,00));
  g.vertices.push(new THREE.Vector3(0,-100,00));
  var l = new THREE.Line(g, material);
  scene.add(l);
var material = new THREE.LineBasicMaterial({
    color: 0x0000ff
  });
  var g = new THREE.Geometry();
  g.vertices.push(new THREE.Vector3(0,0,100));
  g.vertices.push(new THREE.Vector3(0,0,-100));
  var l = new THREE.Line(g, material);
  scene.add(l);
}
  
  p.tossAcoin = function(minX, maxX, minY, maxY, density){
  
    var dx = Math.floor((maxX-minX)/density);
    var dy = Math.floor((maxY-minY)/density);
    
    var maze = new Array();
    
    var y = minY;
    for(var i = 0; i < density; ++i){
      var row = new Array();
      var x = minX;
      for(var j = 0; j < density; ++j){
        
        var node = {};
        if(i == 0){
          node.bottom = true;
        }
        else{
          node.bottom = maze[i-1][j].up
        }
        
        if(node.bottom){
          var bottom = new THREE.Geometry();
          bottom.dynamic = true;
          bottom.vertices.push(new THREE.Vector3(x, y, 0));
          bottom.vertices.push(new THREE.Vector3(x+dx, y, 0));
          node.bottomGeometry = bottom;
          this.horizontal.push(bottom);
        }
        
        if(j == 0){
          node.left = true;
        }
        else{
          node.left = row[j-1].right;
        }
        
        if(node.left){
          var left = new THREE.Geometry();
          left.dynamic = true;
          left.vertices.push(new THREE.Vector3(x, y, 0));
          left.vertices.push(new THREE.Vector3(x, y+dy, 0));
          node.leftGeometry = left;
          this.vertical.push(left);
        }
        
        //var coin = Math.floor(Math.random()*2);
        var coin = Math.floor(this.random.nextFloat()*2);
        if(coin%2 ==0){
          node.up = false;
          node.right = true;
        }
        else{
          node.up = true;
          node.right = false;
        }
        
        if(node.right && i == density-1){
          var right = new THREE.Geometry();
          right.dynamic = true;
          right.vertices.push(new THREE.Vector3(x+dx, y, 0));
          right.vertices.push(new THREE.Vector3(x+dx, y, 0));
          
          node.rightGeometry = right;
          this.vertical.push(right);
        }
        
        if(node.up && j == density-1){
          var up = new THREE.Geometry();
          up.dynamic = true;
          up.vertices.push(new THREE.Vector3(x, y+dy, 0));
          up.vertices.push(new THREE.Vector3(x+dx, y+dy, 0));
          
          node.upGeometry = up;
          this.horizontal.push(up);
        }
        
        x += dx;
        row.push(node);
      }
      
      y += dy;
      maze.push(row);
    }
    
    return maze;
  }
  
  p.divide = function(minX, maxX, minY, maxY, rDepth){
  
    var x = Math.floor((maxX-minX)/2+minX);
    var y = Math.floor((maxY-minY)/2+minY);
    
    var wall = new THREE.Geometry();
    wall.dynamic = true;
    ++rDepth;
    if(rDepth > this.recursionLimit){
      // Empty by design -poro
    }
    else{
      //right upper corner
      this.divide(minX, x, minY, y, rDepth);
      //left lower corner
      this.divide(x, maxX, y, maxY, rDepth);
      //right lower corner
      this.divide(minX, x, y, maxY, rDepth);
      //left upper corner
      this.divide(x, maxX, minY, y, rDepth);
    }
    var coin = Math.floor(this.random.nextFloat()*2);
    if(coin%2 == 0){
      wall.vertices.push(new THREE.Vector3(minX, y, 0));
      wall.vertices.push(new THREE.Vector3(maxX, y, 0));
      this.horizontal.push(wall); 
    }
    else{
      wall.vertices.push(new THREE.Vector3(x, minY, 0));
      wall.vertices.push(new THREE.Vector3(x, maxY, 0));
      this.vertical.push(wall); 
    }
    if(rDepth > this.recursionLimit){
      return;
    }
    
  }
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
	}
	
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
    
	}


  p.rubikX = function(td){
    this.group1.translateZ(20.6);
    this.group1.translateX(20.6);
    this.group1.translateY(20.6);
    this.group1.rotation.x += 0.07*td;
    this.group1.translateX(-20.6);
    this.group1.translateZ(-20.6);
    this.group1.translateY(-20.6);
  }

  p.clearX = function(){
      this.group1.translateZ(20.6);
      this.group1.translateX(20.6);
      this.group1.translateY(20.6);
      this.group1.rotation.x =0;
      this.group1.translateX(-20.6);
      this.group1.translateZ(-20.6);
      this.group1.translateY(-20.6);
      this.endCommon();
  }

  p.setX = function() {
    this.group1 = new THREE.Object3D();
      for(var i =0; i < this.cubes.length; ++i){
        var cube = this.cubes[i];
        if(cube.position.x >= 31){
          this.group1.add(cube);
        }
      }
      this.scene2.add(this.group1);
  }

  p.rubikY = function(td){
    this.group1.translateZ(20.6);
    this.group1.translateX(20.6);
    this.group1.translateY(20.6);
    this.group1.rotation.y += 0.07*td;
    this.group1.translateX(-20.6);
    this.group1.translateZ(-20.6);
    this.group1.translateY(-20.6);
  }

  p.clearY = function(){
      this.group1.translateZ(20.6);
      this.group1.translateX(20.6);
      this.group1.translateY(20.6);
      this.group1.rotation.y = 0;
      this.group1.translateX(-20.6);
      this.group1.translateZ(-20.6);
      this.group1.translateY(-20.6);
      this.endCommon();
  }

  p.setY = function() {
    this.group1 = new THREE.Object3D();
      for(var i =0; i < this.cubes.length; ++i){
        var cube = this.cubes[i];
        if(cube.position.y >= 31){
          this.group1.add(cube);
        }
      }
      this.scene2.add(this.group1);
  }

  p.rubikZ = function(td){
    this.group1.translateZ(20.6);
    this.group1.translateX(20.6);
    this.group1.translateY(20.6);
    this.group1.rotation.z += 0.07*td;
    this.group1.translateX(-20.6);
    this.group1.translateZ(-20.6);
    this.group1.translateY(-20.6);
  }

  p.clearZ = function(){
      this.group1.translateZ(20.6);
      this.group1.translateX(20.6);
      this.group1.translateY(20.6);
      this.group1.rotation.z = 0;
      this.group1.translateX(-20.6);
      this.group1.translateZ(-20.6);
      this.group1.translateY(-20.6);
      this.endCommon();
  }

  p.setZ = function() {
    this.group1 = new THREE.Object3D();
      for(var i =0; i < this.cubes.length; ++i){
        var cube = this.cubes[i];
        if(cube.position.z >= 31){
          this.group1.add(cube);
        }
      }
      this.scene2.add(this.group1);
  }

  p.endCommon = function(){
    
  }
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime,td, timespent){
	if(!this.endd)
		this.brightnessEffect.uniforms.brightness.value = 0;
	this.main.effectBloom.materialCopy.uniforms.opacity.value = 5+ this.main.drumDelta*2;
	
  this.effectTime += timespent;
  // Camera phasings
  this.dotScreenEffect.uniforms['amount'].value = wideload.Random.nextFloat()*(0.00001)+0.0005;
  if(this.phase == 1){
    this.camera2.position.x += 0.05*td;
    //this.camera2.position.y += 0.05*td;
    if(this.effectTime >= 7000){
      this.brightnessEffect.uniforms.brightness.value -= 0.02;
      this.brightnessEffect.uniforms.brightness.value = Math.max(this.brightnessEffect.uniforms.brightness.value,-1);
    }
    if(this.effectTime >= 7700){
      this.phase = 2;
      this.camera2.position.x = 65;
      this.camera2.position.y = 45;
      this.camera2.position.z = 45;
      this.camera2.look.y = 40;
      this.camera2.look.x = 20;
      this.camera2.look.z = 20;
      this.camera2.lookAt(this.camera2.look);
    }
  }  
  if(this.phase == 2){
    this.brightnessEffect.uniforms.brightness.value += 0.02;
      this.brightnessEffect.uniforms.brightness.value = Math.min(this.brightnessEffect.uniforms.brightness.value,0.20);
      this.brightnessEffect.uniforms.contrast.value = 0.2;
    this.uniforms.phase.value = 2.0;
    var previous = this.camera2.position.clone();
    //this.camera2.position.x += 0.06*td;
    this.camera2.position.y -= 0.06*td;
    //this.camera2.position.z += 0.04*td;
    this.camera2.look.y -= 0.06*td;
    
    this.camera2.lookAt(this.camera2.look);
    if(this.effectTime >= 18000){
      this.phase = 3;
      /*this.camera2.position.x += 85;
      this.camera2.position.z -= 45;
      this.camera2.position.y += 55;
      this.camera2.look.y = 20;
      this.camera2.look.x = 20;
      this.camera2.look.z = 20;*/
      this.camera2.lookAt(this.camera2.look);
      this.steps = 0;
    }
  }
  if(this.phase == 3)
  {
      this.phase = 4;
  }
  if(this.phase == 4){
    this.camera2.position.y -= 0.01*td;
    this.camera2.look.y -= 0.01*td;
    this.uniforms.phase.value = 4.0;
    //this.camera2.position.z -= 0.09*td;
    //this.camera2.position.z += 0.6*td;
    //this.camera2.position.y += 0.5*td;
    this.camera2.lookAt(this.camera2.look);
    
    if(this.effectTime >= 19544){
      this.phase = 5;
    }
    for(var i = 0; i < this.cubes.length;++i){
      var cube = this.cubes[i];
      if(cube.addedTotal < 0.3)
      {
        cube.distanceToCenter = cube.position.clone().sub(new THREE.Vector3(20,20,20));
        cube.position.add(cube.distanceToCenter.clone().multiplyScalar(0.02));
        cube.addedTotal += 0.02
        }
    }
	this.camY = this.camera2.position.y;
	this.camX = this.camera2.position.x;
	this.camZ = this.camera2.position.z;
	
	this.ctx = this.camera2.look.x;
	this.cty = this.camera2.look.y;
	this.ctz = this.camera2.look.z;
	
  }
  
  if(this.phase == 5 && this.effectTime >= 19644){
    
    if(this.camera2.position.x >= 33){
	
	
	
    //this.camera2.position.x -= 0.05*td;
    this.camX -= 0.05*td;
	this.ctx += 0.01*td;
    //this.camera2.look.z += 0.01*td;
	this.cty += 0.04*td;
    //this.camera2.look.y += 0.04*td;
    //this.camera2.lookAt(this.camera2.look);
    }
    else if(this.camera2.position.x > 22){
      this.camX -= 0.05*td;
	  this.camZ -= 0.06*td;
	  this.ctz-=0.13*td;
	  this.camY +=0.01*td;
	  this.cty -= 0.09*td;
	  
	  /*this.camera2.position.x -= 0.05*td;
      this.camera2.position.z -= 0.06*td;
      this.camera2.look.z -= 0.13*td;
      this.camera2.position.y += 0.01*td;
      this.camera2.look.y -= 0.09*td;
      this.camera2.lookAt(this.camera2.look);*/
    }
    if(this.camera2.position.z >= 35){
		this.camZ -= 0.04*td;
//      this.camera2.position.z -= 0.04*td;
    }
    if(this.camera2.position.x <= 23){
      this.phase = 6;
    }
	this.camera2.position.x += (this.camX - this.camera2.position.x)/25;
	this.camera2.position.y += (this.camY - this.camera2.position.y)/25;
	this.camera2.position.z += (this.camZ - this.camera2.position.z)/25;
	this.camera2.look.x += (this.ctx - this.camera2.look.x)/25;
	this.camera2.look.y += (this.cty - this.camera2.look.y)/25;
	this.camera2.look.z += (this.ctz - this.camera2.look.z)/25;
	
	this.camera2.lookAt(this.camera2.look);
  }
  if(this.phase == 6 )
  {
    for(var i = 0; i < this.cubes.length;++i){
      var cube = this.cubes[i];
      if(cube.addedTotal > 0.04)
      {
        cube.position.add(cube.distanceToCenter.clone().multiplyScalar(-0.02));
        cube.addedTotal -= 0.02;
      }
      else{
        cube.position = cube.originalPosition.clone();
      }
    
    }
    this.camera2.look.x += Math.cos(Math.PI + elapsedtime/1200)/2;
    this.camera2.look.y += Math.sin(Math.PI*3/4 + elapsedtime/400)/10;
    this.camera2.look.z += Math.cos(elapsedtime/800)/3;
    this.camera2.lookAt(this.camera2.look);
	this.endd = true;
    this.brightnessEffect.uniforms.brightness.value -= 0.0011*td;
    this.brightnessEffect.uniforms.contrast.value += 0.0010*td;
	if(this.brightnessEffect.uniforms.brightness.value < -1)
		this.brightnessEffect.uniforms.brightness.value = -1;
		
  }
  
  // LINE DRAW! DO NOT TOUCH!! vvv
  if(this.linesInDrawing.length<15){
    for(var i = 0; i < 9; ++i){
      
      if(this.countV < this.vertical.length){
        
        var line = new THREE.Line(this.vertical[this.countV], this.material);
        this.maze.add(line);
        line.ready = false;
        this.linesInDrawing.push(line);
        line.stopPoint = line.geometry.vertices[0];
        line.geometry.vertices[0] = line.geometry.vertices[1].clone();
        ++this.countV;
        line.increasetimes = 0;
        
      }
      if(this.countH < this.horizontal.length){
        
        var line = new THREE.Line(this.horizontal[this.countH], this.material);
        line.ready = false;
        this.linesInDrawing.push(line);
        this.maze.add(line);
        line.stopPoint = line.geometry.vertices[0];
        line.geometry.vertices[0] = line.geometry.vertices[1].clone();
        ++this.countH;
line.increasetimes = 0;

      }
    }
  }
    for(var i = 0; i < this.linesInDrawing.length; ++i){
      var line = this.linesInDrawing[i];
      if(!line.ready){
    //  if(line.geometry.vertices[1].x != line.stopPoint.x && line.geometry.vertices[1].y != line.stopPoint.y){
        var multiplication = 1/10*td;
        if(line.totalmulti == undefined){
        line.totalmulti = multiplication;
        }
        else
        {
          line.totalmulti += multiplication;
        }
        if(line.totalmulti < 1){
          line.geometry.vertices[0].add((line.stopPoint.clone().sub(line.geometry.vertices[1])).multiplyScalar(multiplication));
        }
        else{
          line.ready = true;
        }
        
        //line.geometry.vertices[1].x++;
        line.geometry.verticesNeedUpdate = true;
     // }
     }
     else{
      line.geometry.vertices[0] = line.stopPoint.clone();
      line.geometry.verticesNeedUpdate = true;
      this.linesInDrawing.splice(i,1);
     }
    }
if(this.main.drumDelta > 0.02 && !this.endd && this.phase != 6)
	this.brightnessEffect.uniforms.brightness.value = this.main.drumDelta*0.8;
    // Line draw ended
	}


	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
    this.main.renderer.render(this.scene, this.cameraO, this.textureTarget);
		//this.main.renderer.render(this.scene2, this.camera2, this.renderTarget);
    this.composer.render();
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime){
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	}
	
}())