//Namespace
this.wideload = this.wideload || {};

(function(){
	
	//Constructor
	var Main = function(){
		
		//we can start after the sound is loaded and we are in fullscreen
		Main.LOAD_COMPLETED = {sound: false, fullScreen: false};

		this.parts = [
		
		//MAIN TIMING
		
			new wideload.Part2(0, 0, this), //45 secs
			new wideload.Maze(500, 0, this), //49,5 secs
			new wideload.ReefPart(49500+500,0,this), //32 secs
			new wideload.Part3(27400+49500+500,0, this), //46,5 secs + 2 sec of black screen
			new wideload.ParticlePart(40200+27400+49500+500, 0, this), //73 secs
			//new wideload.Part3(73000+48500+30000+25000+20000,0, this),
			new wideload.MoluCube(66800+40200+27400+49500+500, 0, this)
		//TESTING PARTS
		
			//new wideload.Part1(0, 0, this),
			//new wideload.Part2(100,0, this),
			//new wideload.Part3(2000,0, this),
		//	new wideload.ReefPart(2001,0,this),
		//	new wideload.ParticlePart(200+0*48500, 0, this) 
		//	new wideload.MoluCube(0,0, this),
			
		//	new wideload.Part3(2000,0, this)*/
		];
		this.soundPlaying= false;
		
		//Add listeners for windowed & fullscreen
		document.getElementById("fullscreen").addEventListener('click', createjs.proxy(this.toFullScreen, this), false);
		document.getElementById("windowed").addEventListener('click', createjs.proxy(this.toFullScreen, this), false);
		
		//Add listener for bg music.
		createjs.Sound.addEventListener("fileload", createjs.proxy(this.soundLoaded, this));
		createjs.Sound.registerSound("bin/bg.mp3|bin/bg.ogg", "bg");
		
		this.drumDelta = 0;
		this.otherDelta = 0;
		this.drumIndex = 0;
		this.otherIndex = 0;
		this.drumSync = [
			6556,
			12846,
			19225,
			25603,
			31982,
			38449,
			44562,
			54500, // OK
			57815, // OK
			60750, // OK
			64205, // OK
			64660,
			65550,
			66236,
			67271,
			68411,
			69245,
			70169,
			70727,
			71338,
			71987,
			73139,
			73772,
			74560,
			75398,
			76230,
			76834,
			77800,
			77800+200,
			77800+950,
			77800+200*2,
			77800+950*2,
			77800+200*3,
			77800+950*3,
			77800+200*4,
			77800+950*4,
			77800+200*5,
			77800+950*6,
		];
		
		this.otherSync = [
			
		];
	}
	
	//Prototype reference.
	var p = Main.prototype;
	
	/**
	* Mode selection handler.
	*/
	p.toFullScreen = function(e)
	{
		//Check if target is fullscreen-button
		this.fullscreen = e.target == document.getElementById("fullscreen");
		
		//Initialize the program.
		this.initialize();
		
		//Set element states
		var element = this.renderer.domElement;
		var demoEl = document.getElementById("demo");
		if(this.fullscreen)
		{
			if (demoEl.requestFullscreen) {
			  demoEl.requestFullscreen();
			} else if (demoEl.mozRequestFullScreen) {
			  demoEl.mozRequestFullScreen();
			} else if (demoEl.webkitRequestFullscreen) {
			  demoEl.webkitRequestFullscreen();
			} else{
			  console.log("fail");
			}
        }
        document.getElementById("fullscreen").style.display = "none";
        document.getElementById("windowed").style.display = "none";
        Main.LOAD_COMPLETED.fullScreen = true;
		var greets = document.getElementById("greets");
        //Add delay if going to fullscreen.
		if(e.target == document.getElementById("fullscreen"))
		{ 
			window.setTimeout( createjs.proxy(this.checkStart,this),5000);
			greets.style.width = this.width+"px";
			greets.style.height = this.height+"px";
		}
		else
		{
			element.style.position="absolute";
			element.style.top = "50%";
			element.style.left = "50%";
			element.style.marginTop = "-360px";
			element.style.marginLeft= "-640px";
			
			greets.style.top = "50%";
			greets.style.left = "50%";
			greets.style.marginTop = "-360px";
			greets.style.marginLeft= "-640px";
			greets.style.width = this.width+"px";
			greets.style.height = this.height+"px";
			
			//Center the element.
			//element.style.margin = "auto";
			//Continue to startup routine.
			this.checkStart();
		}
	}
	
	/**
	* Sound loaded -handler
	*/
	p.soundLoaded = function(){
		Main.LOAD_COMPLETED.sound = true;
		this.checkStart();
	}
  
	/**
	* Check if the demo can be started.
	*/
	p.checkStart = function(){
		if(Main.LOAD_COMPLETED.sound && Main.LOAD_COMPLETED.fullScreen){
			//Start the sound if not playing
			if(!this.soundPlaying){
				this.soundPlaying = true;
				this.bgSound = createjs.Sound.play("bg");
			//	this.bgSound.setVolume(0);
			}
			//tmn leveys/korkeus tulee olla sama kuin RESO.x/RESO.y
			this.display = new THREE.Mesh(new THREE.PlaneGeometry(this.width, this.height),
										 new THREE.MeshBasicMaterial({map : this.parts[0].renderTarget}));
			this.display.position.z = -200;
			var copypass = new THREE.RenderPass(THREE.CopyPass);
			copypass.renderToScreen = true;
			this.scene.add(this.display);
				var renderModel = new THREE.RenderPass( this.scene, this.camera );
                    this.effectBloom = new THREE.BloomPass( 2.5, 20, 18 , 256);
                    var effectScreen = new THREE.ShaderPass( THREE.ShaderExtras[ "screen" ] );
                    effectScreen.renderToScreen = true;
                    this.composer = new THREE.EffectComposer( this.renderer );
                    this.composer.addPass( renderModel );
                    this.composer.addPass( this.effectBloom );
                    this.composer.addPass( effectScreen );
			
			this.parts[0].begin(0);

			this.mainLoop();
		}
	}
  
	/**
	* Initialize the main scene & other related stuff.
	*/
	p.initialize = function()
	{
		//because demo is in fullscreen mode setting width and height according to
		//screen property should work. 
		if(this.fullscreen)
		{
			var w = screen.width;
			var h = screen.height;
			//TODO - calculate the dimensions so that black borders can be applied
			this.width = w;
			this.height = h;
		}
		else
		{
			this.width = 1280;
			this.height = 720;
		}
		
		//Build the renderer.
		this.renderer = new THREE.WebGLRenderer();
		this.renderer.setSize(this.width, this.height);
		this.renderer.setClearColor(0x000000);
		
		this.renderer.domElement.style.width = this.width;
		this.renderer.domElement.style.height = this.height;
		
		//Add the renderer element.
		document.getElementById("demo").appendChild( this.renderer.domElement );
		
		
		//Main render targets resolution. Parts can have different targets.
		this.resolution = [2048, 2048];
		
		this.currentRT = new THREE.WebGLRenderTarget(this.resolution[0], this.resolution[1]);
		this.previousRT = new THREE.WebGLRenderTarget(this.resolution[0], this.resolution[1]);
		
		//Create the main scene that displays only resulting rendertarget
		this.scene = new THREE.Scene();
		
		//Camera to watch the rendertarget drawn to plane.
		this.camera = new THREE.OrthographicCamera(-(this.width/2), this.width/2, (this.height/2), -(this.height/2));
		this.camera.position.z = 400;
		this.scene.add(this.camera);
		
		this.activeCamera = this.camera;
		
		//var ambientLight = new THREE.AmbientLight(0xE6E8FA);
		//this.scene.add(ambientLight);
		
		this.currentPart = 0;
		this.frameCount = 0;
		this.timeCount = 0;
		
		//Initial render.
		//this.renderer.render(this.scene, this.camera);
		
		
		for(var i = 0; i < this.parts.length; i++){
			//Initialize the parts
			var part = this.parts[i];
			part.width = this.width;
			part.height = this.height;
			part.initialize();
			if(i == 0)
				part.prepare();
		}
		this.previous = 0;
	}
	
	p.mainLoop = function(){
		
		if(this.lastTime == undefined){
			this.lastTime = Date.now();
		}
		
		var timeSpent = Date.now()-this.lastTime;		
		this.lastTime = Date.now();
		var curPart = null;
		if(this.currentPart < this.parts.length){
			curPart = this.parts[this.currentPart];

		}
		var nextPart = null;//
		if(this.currentPart < this.parts.length-1){
			nextPart = this.parts[this.currentPart+1];
		}
		
		var time = this.bgSound.getPosition();
		var td = (time - this.previous) / 22;
		this.previous = time;
		if(time == 0)
			td = 1;
		if(time == 0 && this.currentPart > 0)
			time = this.bgSound.length;
		
		this.drumDelta -= 0.05;
		this.otherDelta -= 0.05;
		if(this.drumDelta < 0)
			this.drumDelta = 0;
		if(this.otherDelta < 0)
			this.otherDelta = 0;
		if( this.drumIndex < this.drumSync.length && time > this.drumSync[this.drumIndex])
		{
		console.log("drum " + time);
			this.drumDelta = 1;
			this.drumIndex++;
		}
		if( this.otherIndex < this.otherSync.length && time > this.otherSync[this.otherIndex])
		{
			this.otherDelta = 1;
			this.otherIndex++;
		}
		
		
		if(curPart){
			//Prerender handles any update related stuff before actual render call.
			curPart.preRender(time,td,timeSpent);
			
			//Render the current element to given rendertarget. Part itself handles the rendering.
			curPart.render(time, curPart.renderTarget,td,timeSpent);
			//Render the part to main canvas
			
			++this.frameCount;
			if(nextPart && this.bgSound.getPosition() > nextPart.beginTime){
			
				//Swap the rendertarget
				//TODO - find out if map can be changed without redoing whole item
				this.scene.remove(this.display);
				this.display = new THREE.Mesh(new THREE.PlaneGeometry(this.width, this.height),
										 new THREE.MeshBasicMaterial({map : nextPart.renderTarget}));
				this.display.position.z = -200;
				this.scene.add(this.display);
				this.currentPart++;
				
				//Render the current to previous.
				curPart.endPart(time);
				nextPart.prepare(time,curPart.renderTarget);
				nextPart.begin(time);
			//	
				console.log("Swap to part " + this.currentPart+ " at " + time);
			}
			this.renderer.clear();
			this.renderer.autoClear = false
			this.composer.render();		

			
			requestAnimationFrame( createjs.proxy(this.mainLoop, this) );
			$("#timestamp").html(Math.round(time));
		}		
	};
	
	//Expose the class
	wideload.Main = Main;
}())