//Namespace
this.wideload = this.wideload || {};

/**
* Main class for each part of the demo
*/

(function(){
	
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	  @param main Reference to main class
	*/
	var BasePart = function(beginTime, prepareTime, main){
		this.main = main;
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
	}
	wideload.BasePart = BasePart;
	
	var p = BasePart.prototype;
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(){
		this.scene = new THREE.Scene();
		this.camera = new THREE.OrthographicCamera(-(this.main.resolution[0]/2), this.main.resolution[0]/2, this.main.resolution[1]/2, -(this.main.resolution[1]/2));
		this.camera.position.z = 1;
		this.scene.add(this.camera);
		this.renderTarget = new THREE.WebGLRenderTarget(this.main.resolution[0], this.main.resolution[1]);
	}
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous parts rendertarget.
	*/
	p.prepare = function(elapsedtime,previous){
		
	}
	
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
	
	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime){
		
	}

	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime,renderTarget){
		
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime,renderTarget){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	
	}
	
}())