/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import core.AbstractScreen;
import core.OfficeRunnerGame;

public class MenuScreen
extends AbstractScreen {
    private Texture bg;
    private Texture menuGame;
    private Texture menuOptions;
    private Texture menuCredits;
    private Texture menuExit;
    private float[][] coords = new float[4][2];
    boolean loaded = true;
    boolean togglingBoolean = true;
    float counter = 0.0f;
    BitmapFont font;
    private int selected = 1;

    public MenuScreen(OfficeRunnerGame gameObj) {
        super(gameObj);
        this.game.tweenM.killAll();
        this.bg = new Texture(Gdx.files.internal("menu/menubg.png"));
        this.menuGame = new Texture(Gdx.files.internal("menu/Start.png"));
        this.menuOptions = new Texture(Gdx.files.internal("menu/Options.png"));
        this.menuCredits = new Texture(Gdx.files.internal("menu/Credits.png"));
        this.menuExit = new Texture(Gdx.files.internal("menu/Exit.png"));
        Texture ft = new Texture(Gdx.files.internal("data/font.png"));
        ft.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Nearest);
        TextureRegion ftr = new TextureRegion(ft);
        this.font = new BitmapFont(Gdx.files.internal("data/font.fnt"), ftr, false);
        this.font.setUseIntegerPositions(true);
        this.font.setFixedWidthGlyphs("0123456789.,");
        this.coords[0][0] = 453.0f;
        this.coords[0][1] = 519.0f;
        this.coords[1][0] = 460.0f;
        this.coords[1][1] = 358.0f;
        this.coords[2][0] = 456.0f;
        this.coords[2][1] = 245.0f;
        this.coords[3][0] = 435.0f;
        this.coords[3][1] = 128.0f;
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this);
        Gdx.input.setCursorCatched(false);
    }

    @Override
    public void render(float delta) {
        super.render(delta);
        Gdx.graphics.getGL20().glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
        this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1280.0f, 720.0f);
        this.batch.begin();
        this.batch.draw(this.bg, 0.0f, 0.0f);
        switch (this.selected) {
            case 1: {
                this.batch.draw(this.menuGame, this.coords[0][0], this.coords[0][1]);
                break;
            }
            case 2: {
                this.batch.draw(this.menuOptions, this.coords[1][0], this.coords[1][1]);
                break;
            }
            case 3: {
                this.batch.draw(this.menuCredits, this.coords[2][0], this.coords[2][1]);
                break;
            }
            case 4: {
                this.batch.draw(this.menuExit, this.coords[3][0], this.coords[3][1]);
            }
        }
        if (this.togglingBoolean) {
            this.font.setScale(0.5f);
            String s = "Use W, S & ENTER to select";
            this.font.draw(this.batch, s, 640.0f - this.font.getBounds((CharSequence)s).width / 2.0f, this.font.getBounds((CharSequence)s).height * 2.0f);
            this.font.setScale(0.5f);
        }
        this.counter += Gdx.graphics.getDeltaTime();
        if (this.counter > 0.5f) {
            this.counter = 0.0f;
            this.togglingBoolean = !this.togglingBoolean;
        }
        this.batch.end();
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 51 || keycode == 19) {
            this.selected = MathUtils.clamp(this.selected - 1, 1, 4);
        }
        if (keycode == 47 || keycode == 20) {
            this.selected = MathUtils.clamp(this.selected + 1, 1, 4);
        }
        if (keycode == 66 || keycode == 62) {
            this.handleEnter(this.selected);
        }
        return false;
    }

    private void handleEnter(int choice) {
        switch (choice) {
            case 1: {
                this.game.setScreen(this.game.gameS);
                break;
            }
            case 2: {
                this.selected = 1;
                break;
            }
            case 3: {
                this.selected = 1;
                break;
            }
            case 4: {
                Gdx.app.exit();
            }
        }
    }
}

