/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.mcburrobit.util.CursorTrail;
import core.AbstractScreen;
import core.OfficeRunnerGame;
import screens.GameScreen;

public class GameoverScreen
extends AbstractScreen {
    private BitmapFont font;
    private String score;
    private CursorTrail ct = new CursorTrail();
    private ImmediateModeRenderer20 r = new ImmediateModeRenderer20(false, true, 0);

    public GameoverScreen(OfficeRunnerGame gameObj, String score) {
        super(gameObj);
        Texture ft = new Texture(Gdx.files.internal("data/font.png"));
        ft.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Nearest);
        TextureRegion ftr = new TextureRegion(ft);
        this.font = new BitmapFont(Gdx.files.internal("data/font.fnt"), ftr, false);
        this.font.setUseIntegerPositions(true);
        this.font.setFixedWidthGlyphs("0123456789.,");
        this.score = score;
        Gdx.input.setInputProcessor(this);
        Gdx.input.setCursorCatched(false);
    }

    @Override
    public void render(float delta) {
        super.render(delta);
        Gdx.graphics.getGL20().glClearColor(0.125f, 0.125f, 0.125f, 1.0f);
        this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1280.0f, 720.0f);
        this.batch.begin();
        this.font.setScale(1.0f);
        this.font.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        String s = "GAME OVER";
        this.font.draw(this.batch, s, 640.0f - this.font.getBounds((CharSequence)s).width / 2.0f, 780.0f);
        this.font.setScale(0.25f);
        this.font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        s = "Press ESC to return to Menu, any other key to retry.";
        this.font.draw(this.batch, s, 640.0f - this.font.getBounds((CharSequence)s).width / 2.0f, this.font.getBounds((CharSequence)s).height * 2.0f + 10.0f);
        s = "Your score was " + this.score;
        this.font.setScale(0.7f);
        this.font.draw(this.batch, s, 640.0f - this.font.getBounds((CharSequence)s).width / 2.0f, 360.0f + this.font.getBounds((CharSequence)s).height);
        this.batch.end();
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 131) {
            this.game.setScreen(this.game.menuS);
            return false;
        }
        this.game.gameS.dispose();
        this.game.gameS = new GameScreen(this.game);
        this.game.setScreen(this.game.gameS);
        return false;
    }
}

