/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import lombok.core.AST;
import lombok.core.ImportList;
import lombok.core.LombokNode;
import lombok.core.TypeLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolver {
    private ImportList imports;

    public TypeResolver(ImportList importList) {
        this.imports = importList;
    }

    public boolean typeMatches(LombokNode<?, ?, ?> context, String fqn, String typeRef) {
        return this.typeRefToFullyQualifiedName(context, TypeLibrary.createLibraryForSingleType(fqn), typeRef) != null;
    }

    public String typeRefToFullyQualifiedName(LombokNode<?, ?, ?> context, TypeLibrary library, String typeRef) {
        String qualified = library.toQualified(typeRef);
        if (qualified == null) {
            return null;
        }
        if (typeRef.equals(qualified)) {
            return typeRef;
        }
        String fromExplicitImport = this.imports.getFullyQualifiedNameForSimpleName(typeRef);
        if (fromExplicitImport != null) {
            return fromExplicitImport.equals(qualified) ? qualified : null;
        }
        String pkgName = qualified.substring(0, qualified.length() - typeRef.length() - 1);
        if (!this.imports.hasStarImport(pkgName)) {
            return null;
        }
        LombokNode<Object, Object, Object> n = context;
        while (n != null) {
            if (n.getKind() == AST.Kind.TYPE && typeRef.equals(n.getName())) {
                return null;
            }
            if (n.getKind() == AST.Kind.STATEMENT || n.getKind() == AST.Kind.LOCAL) {
                Object newN = n.directUp();
                if (newN == null) break;
                if (((LombokNode)newN).getKind() == AST.Kind.STATEMENT || ((LombokNode)newN).getKind() == AST.Kind.INITIALIZER || ((LombokNode)newN).getKind() == AST.Kind.METHOD) {
                    for (LombokNode child : ((LombokNode)newN).down()) {
                        if (child.getKind() == AST.Kind.TYPE && typeRef.equals(child.getName())) {
                            return null;
                        }
                        if (child != n) continue;
                        break;
                    }
                }
                n = newN;
                continue;
            }
            if (n.getKind() == AST.Kind.TYPE || n.getKind() == AST.Kind.COMPILATION_UNIT) {
                for (LombokNode child : n.down()) {
                    if (child.getKind() != AST.Kind.TYPE || !typeRef.equals(child.getName())) continue;
                    return null;
                }
            }
            n = n.directUp();
        }
        return qualified;
    }
}

