/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.HashMap;
import java.util.Map;

public class TypeLibrary {
    private final Map<String, String> unqualifiedToQualifiedMap;
    private final String unqualified;
    private final String qualified;

    public TypeLibrary() {
        this.unqualifiedToQualifiedMap = new HashMap<String, String>();
        this.unqualified = null;
        this.qualified = null;
    }

    private TypeLibrary(String fqnSingleton) {
        this.unqualifiedToQualifiedMap = null;
        this.qualified = fqnSingleton;
        int idx = fqnSingleton.lastIndexOf(46);
        this.unqualified = idx == -1 ? fqnSingleton : fqnSingleton.substring(idx + 1);
    }

    public static TypeLibrary createLibraryForSingleType(String fqnSingleton) {
        return new TypeLibrary(fqnSingleton);
    }

    public void addType(String fullyQualifiedTypeName) {
        int idx = (fullyQualifiedTypeName = fullyQualifiedTypeName.replace("$", ".")).lastIndexOf(46);
        if (idx == -1) {
            throw new IllegalArgumentException("Only fully qualified types are allowed (and stuff in the default package is not palatable to us either!)");
        }
        String unqualified = fullyQualifiedTypeName.substring(idx + 1);
        if (this.unqualifiedToQualifiedMap == null) {
            throw new IllegalStateException("SingleType library");
        }
        this.unqualifiedToQualifiedMap.put(unqualified, fullyQualifiedTypeName);
        this.unqualifiedToQualifiedMap.put(fullyQualifiedTypeName, fullyQualifiedTypeName);
    }

    public String toQualified(String typeReference) {
        if (this.unqualifiedToQualifiedMap == null) {
            if (typeReference.equals(this.unqualified) || typeReference.equals(this.qualified)) {
                return this.qualified;
            }
            return null;
        }
        return this.unqualifiedToQualifiedMap.get(typeReference);
    }
}

