/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import core.OfficeRunnerGame;

public class AbstractScreen
extends InputAdapter
implements Screen {
    protected SpriteBatch batch;
    protected Matrix4 normalProj;
    protected boolean doneLoading;
    protected OfficeRunnerGame game;
    private float timer;
    private String className;

    public AbstractScreen(OfficeRunnerGame gameObj) {
        this.game = gameObj;
        this.batch = new SpriteBatch();
        this.normalProj = new Matrix4().setToOrtho2D(0.0f, 0.0f, OfficeRunnerGame.INTERNAL_RES[0], OfficeRunnerGame.INTERNAL_RES[1]);
        this.doneLoading = false;
        Gdx.app.log("[SCREEN]", "Menu: created.");
        this.timer = 0.0f;
        this.className = this.getClass().getName().replaceAll("screen.", "").substring(1).toUpperCase();
        Gdx.input.setInputProcessor(this);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClear(16640);
        this.timer += Gdx.graphics.getDeltaTime();
        if (this.timer > 2.0f) {
            this.timer = 0.0f;
            this.log("Render.");
        }
    }

    public void log(String str) {
        Gdx.app.log(String.valueOf('[') + this.className + ']', str);
    }

    @Override
    public void resize(int width, int height) {
        Gdx.app.log("[SCREEN]", String.valueOf(this.className) + ": resized.");
    }

    @Override
    public void show() {
        Gdx.app.log("[SCREEN]", String.valueOf(this.className) + ": shown.");
    }

    @Override
    public void hide() {
        this.timer = 0.0f;
        Gdx.app.log("[SCREEN]", String.valueOf(this.className) + ": hidden.");
    }

    @Override
    public void pause() {
        Gdx.app.log("[SCREEN]", String.valueOf(this.className) + ": paused.");
    }

    @Override
    public void resume() {
        Gdx.app.log("[SCREEN]", String.valueOf(this.className) + ": resumed.");
    }

    @Override
    public void dispose() {
        Gdx.app.log("[SCREEN]", String.valueOf(this.className) + ": killed.");
    }
}

