/*
 * Decompiled with CFR 0.152.
 */
package com.mcburrobit.util;

import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;

public class CursorTrail {
    private static final float THICKNESS = 12.0f;
    private static final int LENGTH = 8;
    private Array<Vector2> points;
    private Array<Vector2> tmp = new Array(Vector2.class);
    private Array<Vector2> tmp2 = new Array(Vector2.class);
    private Vector2 tvec = new Vector2();
    public static int iterations = 2;
    public static float simplifyTolerance = 35.0f;

    public CursorTrail() {
        this.points = new Array(true, 8, Vector2.class);
        int i = 0;
        while (i < 8) {
            this.points.add(new Vector2(0.0f, 0.0f));
            ++i;
        }
    }

    public void update(ImmediateModeRenderer20 rend, Vector2 mouse) {
        this.points.removeIndex(0);
        this.points.add(mouse);
        this.tmp2.clear();
        this.tmp.clear();
        this.resolve(this.points, this.tmp2);
        Array<Vector2> rendPoints = new Array<Vector2>(true, 8, Vector2.class);
        int i = 0;
        while (i < this.tmp.size) {
            if (i > 0 && i < this.tmp.size - 1) {
                this.tvec.set(this.tmp.get(i)).sub(this.tmp.get(i - 1)).nor();
                this.tvec.set(-this.tvec.y, this.tvec.x);
                this.tvec.mul(12.0f * ((float)i / (float)this.tmp.size) / 2.0f);
                rendPoints.add(this.tmp.get(i).cpy().add(this.tvec));
                rendPoints.add(this.tmp.get(i).cpy().sub(this.tvec));
            } else if (i == 0) {
                rendPoints.add(this.tmp.get(i));
            } else {
                rendPoints.add(this.tmp.get(i).cpy().add(-5.0f, 0.0f));
                rendPoints.add(this.tmp.get(i).cpy().add(0.0f, -5.0f));
                rendPoints.add(this.tmp.get(i).cpy().add(0.0f, 5.0f));
                rendPoints.add(this.tmp.get(i).cpy().add(5.0f, 0.0f));
                rendPoints.add(this.tmp.get(i).cpy().add(0.0f, -5.0f));
            }
            ++i;
        }
        for (Vector2 v : rendPoints) {
            rend.color(1.0f, 1.0f, 1.0f, 1.0f);
            rend.vertex(v.x, v.y, 0.0f);
        }
    }

    private static void simplify(Array<Vector2> points, float sqTolerance, Array<Vector2> out) {
        int len = points.size;
        Vector2 point = new Vector2();
        Vector2 prevPoint = points.get(0);
        out.clear();
        out.add(prevPoint);
        int i = 1;
        while (i < len) {
            point = points.get(i);
            if (CursorTrail.distSq(point, prevPoint) > sqTolerance) {
                out.add(point);
                prevPoint = point;
            }
            ++i;
        }
        if (!prevPoint.equals(point)) {
            out.add(point);
        }
    }

    public static float distSq(Vector2 p1, Vector2 p2) {
        float dx = p1.x - p2.x;
        float dy = p1.y - p2.y;
        return dx * dx + dy * dy;
    }

    public static void smooth(Array<Vector2> input, Array<Vector2> output) {
        output.clear();
        output.ensureCapacity(input.size * 2);
        output.add(input.get(0));
        int i = 0;
        while (i < input.size - 1) {
            Vector2 p0 = input.get(i);
            Vector2 p1 = input.get(i + 1);
            Vector2 Q = new Vector2(0.75f * p0.x + 0.25f * p1.x, 0.75f * p0.y + 0.25f * p1.y);
            Vector2 R = new Vector2(0.25f * p0.x + 0.75f * p1.x, 0.25f * p0.y + 0.75f * p1.y);
            output.add(Q);
            output.add(R);
            ++i;
        }
        output.add(input.get(input.size - 1));
    }

    public void resolve(Array<Vector2> input, Array<Vector2> output) {
        output.clear();
        if (input.size <= 2) {
            output.addAll(input);
            return;
        }
        if (simplifyTolerance > 0.0f && input.size > 3) {
            CursorTrail.simplify(input, simplifyTolerance * simplifyTolerance, this.tmp);
            input = this.tmp;
        }
        if (iterations <= 0) {
            output.addAll(input);
        } else if (iterations == 1) {
            CursorTrail.smooth(input, output);
        } else {
            int iters = iterations;
            do {
                CursorTrail.smooth(input, output);
                this.tmp.clear();
                this.tmp.addAll(output);
                Array<Vector2> old = output;
                input = this.tmp;
                output = old;
            } while (--iters > 0);
        }
    }
}

