/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.RegionSequenceAttachment;

public class AtlasAttachmentLoader
implements AttachmentLoader {
    private TextureAtlas atlas;

    public AtlasAttachmentLoader(TextureAtlas atlas) {
        if (atlas == null) {
            throw new IllegalArgumentException("atlas cannot be null.");
        }
        this.atlas = atlas;
    }

    @Override
    public Attachment newAttachment(Skin skin, AttachmentType type, String name) {
        RegionAttachment attachment = null;
        switch (type) {
            case region: {
                attachment = new RegionAttachment(name);
                break;
            }
            case regionSequence: {
                attachment = new RegionSequenceAttachment(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attachment type: " + (Object)((Object)type));
            }
        }
        if (attachment instanceof RegionAttachment) {
            TextureAtlas.AtlasRegion region = this.atlas.findRegion(attachment.getName());
            if (region == null) {
                throw new RuntimeException("Region not found in atlas: " + attachment + " (" + (Object)((Object)type) + " attachment: " + name + ")");
            }
            attachment.setRegion(region);
        }
        return attachment;
    }
}

