/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;

public class SkeletonData {
    String name;
    final Array<BoneData> bones = new Array();
    final Array<SlotData> slots = new Array();
    final Array<Skin> skins = new Array();
    Skin defaultSkin;
    final Array<Animation> animations = new Array();

    public void clear() {
        this.bones.clear();
        this.slots.clear();
        this.skins.clear();
        this.animations.clear();
        this.defaultSkin = null;
    }

    public void addBone(BoneData bone) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        this.bones.add(bone);
    }

    public Array<BoneData> getBones() {
        return this.bones;
    }

    public BoneData findBone(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<BoneData> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            BoneData bone = bones.get(i);
            if (bone.name.equals(boneName)) {
                return bone;
            }
            ++i;
        }
        return null;
    }

    public int findBoneIndex(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<BoneData> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            if (bones.get((int)i).name.equals(boneName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addSlot(SlotData slot) {
        if (slot == null) {
            throw new IllegalArgumentException("slot cannot be null.");
        }
        this.slots.add(slot);
    }

    public Array<SlotData> getSlots() {
        return this.slots;
    }

    public SlotData findSlot(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<SlotData> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            SlotData slot = slots.get(i);
            if (slot.name.equals(slotName)) {
                return slot;
            }
            ++i;
        }
        return null;
    }

    public int findSlotIndex(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<SlotData> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            if (slots.get((int)i).name.equals(slotName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Skin getDefaultSkin() {
        return this.defaultSkin;
    }

    public void setDefaultSkin(Skin defaultSkin) {
        this.defaultSkin = defaultSkin;
    }

    public void addSkin(Skin skin) {
        if (skin == null) {
            throw new IllegalArgumentException("skin cannot be null.");
        }
        this.skins.add(skin);
    }

    public Skin findSkin(String skinName) {
        if (skinName == null) {
            throw new IllegalArgumentException("skinName cannot be null.");
        }
        for (Skin skin : this.skins) {
            if (!skin.name.equals(skinName)) continue;
            return skin;
        }
        return null;
    }

    public Array<Skin> getSkins() {
        return this.skins;
    }

    public void addAnimation(Animation animation) {
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        this.animations.add(animation);
    }

    public Array<Animation> getAnimations() {
        return this.animations;
    }

    public Animation findAnimation(String animationName) {
        if (animationName == null) {
            throw new IllegalArgumentException("animationName cannot be null.");
        }
        Array<Animation> animations = this.animations;
        int i = 0;
        int n = animations.size;
        while (i < n) {
            Animation animation = animations.get(i);
            if (animation.name.equals(animationName)) {
                return animation;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }
}

