/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.attachments.Attachment;

public class Skeleton {
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    final Array<Slot> drawOrder;
    Skin skin;
    final Color color;
    float time;
    boolean flipX;
    boolean flipY;
    float x;
    float y;

    public Skeleton(SkeletonData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
        this.bones = new Array(data.bones.size);
        for (BoneData boneData : data.bones) {
            Bone parent = boneData.parent == null ? null : this.bones.get(data.bones.indexOf(boneData.parent, true));
            this.bones.add(new Bone(boneData, parent));
        }
        this.slots = new Array(data.slots.size);
        this.drawOrder = new Array(data.slots.size);
        for (SlotData slotData : data.slots) {
            Bone bone = this.bones.get(data.bones.indexOf(slotData.boneData, true));
            Slot slot = new Slot(slotData, this, bone);
            this.slots.add(slot);
            this.drawOrder.add(slot);
        }
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Skeleton(Skeleton skeleton) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = skeleton.data;
        this.bones = new Array(skeleton.bones.size);
        for (Bone bone : skeleton.bones) {
            Bone parent = bone.parent == null ? null : this.bones.get(skeleton.bones.indexOf(bone.parent, true));
            this.bones.add(new Bone(bone, parent));
        }
        this.slots = new Array(skeleton.slots.size);
        for (Slot slot : skeleton.slots) {
            Bone bone = this.bones.get(skeleton.bones.indexOf(slot.bone, true));
            Slot newSlot = new Slot(slot, this, bone);
            this.slots.add(newSlot);
        }
        this.drawOrder = new Array(this.slots.size);
        for (Slot slot : skeleton.drawOrder) {
            this.drawOrder.add(this.slots.get(skeleton.slots.indexOf(slot, true)));
        }
        this.skin = skeleton.skin;
        this.color = new Color(skeleton.color);
        this.time = skeleton.time;
    }

    public void updateWorldTransform() {
        boolean flipX = this.flipX;
        boolean flipY = this.flipY;
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            bones.get(i).updateWorldTransform(flipX, flipY);
            ++i;
        }
    }

    public void setToSetupPose() {
        this.setBonesToSetupPose();
        this.setSlotsToSetupPose();
    }

    public void setBonesToSetupPose() {
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            bones.get(i).setToSetupPose();
            ++i;
        }
    }

    public void setSlotsToSetupPose() {
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            slots.get(i).setToSetupPose(i);
            ++i;
        }
    }

    public SkeletonData getData() {
        return this.data;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getRootBone() {
        if (this.bones.size == 0) {
            return null;
        }
        return this.bones.first();
    }

    public Bone findBone(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            Bone bone = bones.get(i);
            if (bone.data.name.equals(boneName)) {
                return bone;
            }
            ++i;
        }
        return null;
    }

    public int findBoneIndex(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            if (bones.get((int)i).data.name.equals(boneName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Array<Slot> getSlots() {
        return this.slots;
    }

    public Slot findSlot(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            Slot slot = slots.get(i);
            if (slot.data.name.equals(slotName)) {
                return slot;
            }
            ++i;
        }
        return null;
    }

    public int findSlotIndex(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            if (slots.get((int)i).data.name.equals(slotName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Array<Slot> getDrawOrder() {
        return this.drawOrder;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(String skinName) {
        Skin skin = this.data.findSkin(skinName);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + skinName);
        }
        this.setSkin(skin);
    }

    public void setSkin(Skin newSkin) {
        if (this.skin != null && newSkin != null) {
            newSkin.attachAll(this, this.skin);
        }
        this.skin = newSkin;
    }

    public Attachment getAttachment(String slotName, String attachmentName) {
        return this.getAttachment(this.data.findSlotIndex(slotName), attachmentName);
    }

    public Attachment getAttachment(int slotIndex, String attachmentName) {
        Attachment attachment;
        if (attachmentName == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(slotIndex, attachmentName)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(slotIndex, attachmentName);
        }
        return null;
    }

    public void setAttachment(String slotName, String attachmentName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            Slot slot = slots.get(i);
            if (slot.data.name.equals(slotName)) {
                Attachment attachment = null;
                if (attachmentName != null && (attachment = this.getAttachment(i, attachmentName)) == null) {
                    throw new IllegalArgumentException("Attachment not found: " + attachmentName + ", for slot: " + slotName);
                }
                slot.setAttachment(attachment);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Slot not found: " + slotName);
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void update(float delta) {
        this.time += delta;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }
}

