/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;

public class AnimationState {
    private final AnimationStateData data;
    private Animation current;
    private Animation previous;
    private float currentTime;
    private float previousTime;
    private boolean currentLoop;
    private boolean previousLoop;
    private float mixTime;
    private float mixDuration;
    private Array<QueueEntry> queue = new Array();

    public AnimationState(AnimationStateData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
    }

    public void update(float delta) {
        this.currentTime += delta;
        this.previousTime += delta;
        this.mixTime += delta;
        if (this.queue.size > 0) {
            QueueEntry entry = this.queue.first();
            if (this.currentTime >= entry.delay) {
                this.setAnimationInternal(entry.animation, entry.loop);
                Pools.free(entry);
                this.queue.removeIndex(0);
            }
        }
    }

    public void apply(Skeleton skeleton) {
        if (this.current == null) {
            return;
        }
        if (this.previous != null) {
            this.previous.apply(skeleton, this.previousTime, this.previousLoop);
            float alpha = this.mixTime / this.mixDuration;
            if (alpha >= 1.0f) {
                alpha = 1.0f;
                this.previous = null;
            }
            this.current.mix(skeleton, this.currentTime, this.currentLoop, alpha);
        } else {
            this.current.apply(skeleton, this.currentTime, this.currentLoop);
        }
    }

    public void clearAnimation() {
        this.previous = null;
        this.current = null;
        this.clearQueue();
    }

    private void clearQueue() {
        Pools.freeAll(this.queue);
        this.queue.clear();
    }

    private void setAnimationInternal(Animation animation, boolean loop) {
        this.previous = null;
        if (animation != null && this.current != null) {
            this.mixDuration = this.data.getMix(this.current, animation);
            if (this.mixDuration > 0.0f) {
                this.mixTime = 0.0f;
                this.previous = this.current;
                this.previousTime = this.currentTime;
                this.previousLoop = this.currentLoop;
            }
        }
        this.current = animation;
        this.currentLoop = loop;
        this.currentTime = 0.0f;
    }

    public void setAnimation(String animationName, boolean loop) {
        Animation animation = this.data.getSkeletonData().findAnimation(animationName);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + animationName);
        }
        this.setAnimation(animation, loop);
    }

    public void setAnimation(Animation animation, boolean loop) {
        this.clearQueue();
        this.setAnimationInternal(animation, loop);
    }

    public void addAnimation(String animationName, boolean loop) {
        this.addAnimation(animationName, loop, 0.0f);
    }

    public void addAnimation(String animationName, boolean loop, float delay) {
        Animation animation = this.data.getSkeletonData().findAnimation(animationName);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + animationName);
        }
        this.addAnimation(animation, loop, delay);
    }

    public void addAnimation(Animation animation, boolean loop) {
        this.addAnimation(animation, loop, 0.0f);
    }

    public void addAnimation(Animation animation, boolean loop, float delay) {
        QueueEntry entry = Pools.obtain(QueueEntry.class);
        entry.animation = animation;
        entry.loop = loop;
        if (delay <= 0.0f) {
            Animation previousAnimation = this.queue.size == 0 ? this.current : this.queue.peek().animation;
            delay = previousAnimation != null ? previousAnimation.getDuration() - this.data.getMix(previousAnimation, animation) + delay : 0.0f;
        }
        entry.delay = delay;
        this.queue.add(entry);
    }

    public Animation getAnimation() {
        return this.current;
    }

    public float getTime() {
        return this.currentTime;
    }

    public void setTime(float time) {
        this.currentTime = time;
    }

    public boolean isComplete() {
        return this.current == null || this.currentTime >= this.current.getDuration();
    }

    public AnimationStateData getData() {
        return this.data;
    }

    public String toString() {
        return this.current != null && this.current.getName() != null ? this.current.getName() : super.toString();
    }

    private static class QueueEntry {
        Animation animation;
        boolean loop;
        float delay;

        private QueueEntry() {
        }
    }
}

